<?php

if ( ! function_exists( 'oaza_core_map_masonry_gallery_meta' ) ) {
	function oaza_core_map_masonry_gallery_meta() {
		
		$masonry_gallery_meta_box = oaza_mikado_create_meta_box(
			array(
				'scope' => array( 'masonry-gallery' ),
				'title' => esc_html__( 'Masonry Gallery General', 'oaza-core' ),
				'name'  => 'masonry_gallery_meta'
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_masonry_gallery_item_type',
				'type'          => 'select',
				'default_value' => 'standard',
				'label'         => esc_html__( 'Type', 'oaza-core' ),
				'parent'        => $masonry_gallery_meta_box,
				'options'       => array(
					'standard'    => esc_html__( 'Standard', 'oaza-core' ),
					'with-button' => esc_html__( 'With Button & Border', 'oaza-core' ),
					'textual'     => esc_html__( 'Text With Icon', 'oaza-core' ),
					'simple'      => esc_html__( 'Simple', 'oaza-core' )
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_masonry_gallery_item_size',
				'type'          => 'select',
				'default_value' => 'small',
				'label'         => esc_html__( 'Size', 'oaza-core' ),
				'parent'        => $masonry_gallery_meta_box,
				'options'       => array(
					'small'              => esc_html__( 'Small', 'oaza-core' ),
					'large-width'        => esc_html__( 'Large Width', 'oaza-core' ),
					'large-height'       => esc_html__( 'Large Height', 'oaza-core' ),
					'large-width-height' => esc_html__( 'Large Width/Height', 'oaza-core' )
				)
			)
		);

		oaza_mikado_create_meta_box_field(
			array(
				'name'       => 'mkdf_masonry_gallery_item_content_padding',
				'type'       => 'text',
				'label'      => esc_html__( 'Content Padding (px)', 'oaza-core' ),
				'parent'     => $masonry_gallery_meta_box,
				'dependency' => array(
					'show' => array(
						'mkdf_masonry_gallery_item_type' => array( 'with-button' )
					)
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_masonry_gallery_item_title_tag',
				'type'          => 'select',
				'default_value' => 'h2',
				'label'         => esc_html__( 'Title Tag', 'oaza-core' ),
				'parent'        => $masonry_gallery_meta_box,
				'options'       => oaza_mikado_get_title_tag( true, array( 'span' => esc_html__( 'Custom Heading' ) ) ),
				'dependency'    => array(
					'hide' => array(
						'mkdf_masonry_gallery_item_type' => array( 'simple' )
					)
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'       => 'mkdf_masonry_gallery_item_title_color',
				'type'       => 'color',
				'label'      => esc_html__( 'Title Color', 'oaza-core' ),
				'parent'     => $masonry_gallery_meta_box,
				'dependency' => array(
					'hide' => array(
						'mkdf_masonry_gallery_item_type' => array( 'simple' )
					)
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'       => 'mkdf_masonry_gallery_item_text',
				'type'       => 'text',
				'label'      => esc_html__( 'Text', 'oaza-core' ),
				'parent'     => $masonry_gallery_meta_box,
				'dependency' => array(
					'show' => array(
						'mkdf_masonry_gallery_item_type' => array( 'standard', 'textual', 'with-button' )
					)
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'       => 'mkdf_masonry_gallery_item_text_margin',
				'type'       => 'text',
				'label'      => esc_html__( 'Text Margin (px)', 'oaza-core' ),
				'parent'     => $masonry_gallery_meta_box,
				'dependency' => array(
					'show' => array(
						'mkdf_masonry_gallery_item_type' => array( 'standard', 'with-button', 'textual' )
					)
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_masonry_gallery_item_text_tag',
				'type'          => 'select',
				'default_value' => 'p',
				'label'         => esc_html__( 'Text Tag', 'oaza-core' ),
				'parent'        => $masonry_gallery_meta_box,
				'options'       => oaza_mikado_get_title_tag( true, array( 'p'    => 'p',
				                                                                  'span' => esc_html__( 'Custom Heading' )
				) ),
				'dependency'    => array(
					'show' => array(
						'mkdf_masonry_gallery_item_type' => array( 'standard', 'textual', 'with-button' )
					)
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'       => 'mkdf_masonry_gallery_item_text_color',
				'type'       => 'color',
				'label'      => esc_html__( 'Text Color', 'oaza-core' ),
				'parent'     => $masonry_gallery_meta_box,
				'dependency' => array(
					'show' => array(
						'mkdf_masonry_gallery_item_type' => array( 'standard', 'with-button', 'textual' )
					)
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'       => 'mkdf_masonry_gallery_item_background_color',
				'type'       => 'color',
				'label'      => esc_html__( 'Background Color', 'oaza-core' ),
				'parent'     => $masonry_gallery_meta_box,
				'dependency' => array(
					'show' => array(
						'mkdf_masonry_gallery_item_type' => array( 'with-button' )
					)
				)
			)
		);

		oaza_mikado_create_meta_box_field(
			array(
				'name'       => 'mkdf_masonry_gallery_item_hover_background_color',
				'type'       => 'color',
				'label'      => esc_html__( 'Hover Background Color', 'oaza-core' ),
				'parent'     => $masonry_gallery_meta_box,
				'dependency' => array(
					'show' => array(
						'mkdf_masonry_gallery_item_type' => array( 'with-button' )
					)
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'       => 'mkdf_masonry_gallery_custom_icon',
				'type'       => 'image',
				'label'      => esc_html__( 'Custom Icon', 'oaza-core' ),
				'parent'     => $masonry_gallery_meta_box,
				'dependency' => array(
					'show' => array(
						'mkdf_masonry_gallery_item_type' => array( 'standard', 'textual' )
					)
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'       => 'mkdf_masonry_gallery_icon_margin',
				'type'       => 'text',
				'label'      => esc_html__( 'Icon Margin Bottom (px)', 'oaza-core' ),
				'parent'     => $masonry_gallery_meta_box,
				'dependency' => array(
					'show' => array(
						'mkdf_masonry_gallery_item_type' => array( 'standard', 'textual' )
					)
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'       => 'mkdf_masonry_gallery_button_label',
				'type'       => 'text',
				'label'      => esc_html__( 'Button Label', 'oaza-core' ),
				'parent'     => $masonry_gallery_meta_box,
				'dependency' => array(
					'show' => array(
						'mkdf_masonry_gallery_item_type' => array( 'with-button', 'standard' )
					)
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'       => 'mkdf_masonry_gallery_item_link',
				'type'       => 'text',
				'label'      => esc_html__( 'Link', 'oaza-core' ),
				'parent'     => $masonry_gallery_meta_box,
				'dependency' => array(
					'hide' => array(
						'mkdf_masonry_gallery_item_type' => array( 'simple', 'textual' )
					)
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'       => 'mkdf_masonry_gallery_item_button_margin',
				'type'       => 'text',
				'label'      => esc_html__( 'Button Margin (px)', 'oaza-core' ),
				'parent'     => $masonry_gallery_meta_box,
				'dependency' => array(
					'show' => array(
						'mkdf_masonry_gallery_item_type' => array( 'standard', 'with-button' )
					)
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'       => 'mkdf_masonry_gallery_item_button_type',
				'type'       => 'select',
				'label'      => esc_html__( 'Type', 'oaza-core' ),
				'options'    => array(
					'solid'   => esc_html__( 'Solid', 'oaza-core' ),
					'outline' => esc_html__( 'Outline', 'oaza-core' ),
					'simple'  => esc_html__( 'Simple', 'oaza-core' )
				),
				'parent'     => $masonry_gallery_meta_box,
				'dependency' => array(
					'show' => array(
						'mkdf_masonry_gallery_item_type' => array( 'with-button', 'standard' )
					)
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_masonry_gallery_item_link_target',
				'type'          => 'select',
				'default_value' => '_self',
				'label'         => esc_html__( 'Link Target', 'oaza-core' ),
				'options'       => oaza_mikado_get_link_target_array(),
				'parent'        => $masonry_gallery_meta_box,
				'dependency'    => array(
					'hide' => array(
						'mkdf_masonry_gallery_item_type' => array( 'simple', 'textual' )
					)
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_masonry_gallery_content_skin',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Content Skin', 'oaza-core' ),
				'options'       => array(
					'default' => esc_html__( 'Default', 'oaza-core' ),
					'light'   => esc_html__( 'Light', 'oaza-core' )
				),
				'parent'        => $masonry_gallery_meta_box,
				'dependency'    => array(
					'hide' => array(
						'mkdf_masonry_gallery_item_type' => array( 'simple' )
					)
				)
			)
		);
	}
	
	add_action( 'oaza_mikado_action_meta_boxes_map', 'oaza_core_map_masonry_gallery_meta', 45 );
}