<?php
$content_padding = get_post_meta( $item_id, 'mkdf_masonry_gallery_item_content_padding', true );
$bg_color        = get_post_meta( $item_id, 'mkdf_masonry_gallery_item_background_color', true );
$hover_bg_color  = get_post_meta( $item_id, 'mkdf_masonry_gallery_item_hover_background_color', true );

$holder_styles  = array();
$wrapper_styles = array();
$wrapper_data   = array();

if ( ! empty( $content_padding ) ) {
	$holder_styles[] = 'padding:' . $content_padding;
}
if ( ! empty( $bg_color ) ) {
	$wrapper_styles[] = 'background-color:' . $bg_color;
}
if ( ! empty( $hover_bg_color ) ) {
	$wrapper_data['data-hover-bg-color'] = $hover_bg_color;
}
?>

<article class="mkdf-item-space <?php echo esc_attr( $item_classes ) ?>">
	<div class="mkdf-mg-item-inner">
		<?php echo oaza_core_get_cpt_shortcode_module_template_part( 'masonry-gallery', 'masonry-gallery-list', 'parts/image', '', $params ); ?>
		<div class="mkdf-mg-item-holder" <?php oaza_mikado_inline_style( $holder_styles ); ?>>
			<div class="mkdf-mg-item-wrapper" <?php oaza_mikado_inline_style( $wrapper_styles ); ?> <?php echo oaza_mikado_get_inline_attrs($wrapper_data); ?>>
				<div class="mkdf-mg-item-content">
					<?php echo oaza_core_get_cpt_shortcode_module_template_part( 'masonry-gallery', 'masonry-gallery-list', 'parts/text', '', $params ); ?>
					<?php echo oaza_core_get_cpt_shortcode_module_template_part( 'masonry-gallery', 'masonry-gallery-list', 'parts/title', '', $params ); ?>
					<?php echo oaza_core_get_cpt_shortcode_module_template_part( 'masonry-gallery', 'masonry-gallery-list', 'parts/button', '', $params ); ?>
				</div>
			</div>
		</div>
	</div>
</article>
