<?php

if ( ! function_exists( 'oaza_mikado_map_woocommerce_meta' ) ) {
	function oaza_mikado_map_woocommerce_meta() {
		
		$woocommerce_meta_box = oaza_mikado_create_meta_box(
			array(
				'scope' => array( 'product' ),
				'title' => esc_html__( 'Product Meta', 'oaza' ),
				'name'  => 'woo_product_meta'
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_product_featured_image_size',
				'type'        => 'select',
				'label'       => esc_html__( 'Dimensions for Product List Shortcode', 'oaza' ),
				'description' => esc_html__( 'Choose image layout when it appears in Mikado Product List - Masonry layout shortcode', 'oaza' ),
				'options'     => array(
					''                   => esc_html__( 'Default', 'oaza' ),
					'small'              => esc_html__( 'Small', 'oaza' ),
					'large-width'        => esc_html__( 'Large Width', 'oaza' ),
					'large-height'       => esc_html__( 'Large Height', 'oaza' ),
					'large-width-height' => esc_html__( 'Large Width Height', 'oaza' )
				),
				'parent'      => $woocommerce_meta_box
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_show_title_area_woo_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'oaza' ),
				'description'   => esc_html__( 'Disabling this option will turn off page title area', 'oaza' ),
				'options'       => oaza_mikado_get_yes_no_select_array(),
				'parent'        => $woocommerce_meta_box
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_show_new_sign_woo_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Show New Sign', 'oaza' ),
				'description'   => esc_html__( 'Enabling this option will show new sign mark on product', 'oaza' ),
				'parent'        => $woocommerce_meta_box
			)
		);
	}
	
	add_action( 'oaza_mikado_action_meta_boxes_map', 'oaza_mikado_map_woocommerce_meta', 99 );
}