<?php

if ( ! function_exists( 'oaza_mikado_portfolio_options_map' ) ) {
	function oaza_mikado_portfolio_options_map() {
		
		oaza_mikado_add_admin_page(
			array(
				'slug'  => '_portfolio',
				'title' => esc_html__( 'Portfolio', 'oaza-core' ),
				'icon'  => 'fa fa-camera-retro'
			)
		);
		
		$panel_archive = oaza_mikado_add_admin_panel(
			array(
				'title' => esc_html__( 'Portfolio Archive', 'oaza-core' ),
				'name'  => 'panel_portfolio_archive',
				'page'  => '_portfolio'
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'        => 'portfolio_archive_number_of_items',
				'type'        => 'text',
				'label'       => esc_html__( 'Number of Items', 'oaza-core' ),
				'description' => esc_html__( 'Set number of items for your portfolio list on archive pages. Default value is 12', 'oaza-core' ),
				'parent'      => $panel_archive,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_archive_number_of_columns',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'oaza-core' ),
				'default_value' => 'four',
				'description'   => esc_html__( 'Set number of columns for your portfolio list on archive pages. Default value is Four columns', 'oaza-core' ),
				'parent'        => $panel_archive,
				'options'       => oaza_mikado_get_number_of_columns_array( false, array( 'one', 'six' ) )
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_archive_space_between_items',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'oaza-core' ),
				'description'   => esc_html__( 'Set space size between portfolio items for your portfolio list on archive pages. Default value is normal', 'oaza-core' ),
				'default_value' => 'normal',
				'options'       => oaza_mikado_get_space_between_items_array(),
				'parent'        => $panel_archive
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_archive_image_size',
				'type'          => 'select',
				'label'         => esc_html__( 'Image Proportions', 'oaza-core' ),
				'default_value' => 'landscape',
				'description'   => esc_html__( 'Set image proportions for your portfolio list on archive pages. Default value is landscape', 'oaza-core' ),
				'parent'        => $panel_archive,
				'options'       => array(
					'full'      => esc_html__( 'Original', 'oaza-core' ),
					'landscape' => esc_html__( 'Landscape', 'oaza-core' ),
					'portrait'  => esc_html__( 'Portrait', 'oaza-core' ),
					'square'    => esc_html__( 'Square', 'oaza-core' )
				)
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_archive_item_layout',
				'type'          => 'select',
				'label'         => esc_html__( 'Item Style', 'oaza-core' ),
				'default_value' => 'standard-shader',
				'description'   => esc_html__( 'Set item style for your portfolio list on archive pages. Default value is Standard - Shader', 'oaza-core' ),
				'parent'        => $panel_archive,
				'options'       => array(
					'standard-shader'        => esc_html__( 'Standard - Shader', 'oaza-core' ),
					'standard-switch-images' => esc_html__( 'Standard - Switch Featured Images', 'oaza-core' ),
					'gallery-overlay'        => esc_html__( 'Gallery - Overlay', 'oaza-core' ),
					'gallery-bottom-overlay' => esc_html__( 'Gallery - Bottom Overlay', 'oaza-core' )
				)
			)
		);
		
		$panel = oaza_mikado_add_admin_panel(
			array(
				'title' => esc_html__( 'Portfolio Single', 'oaza-core' ),
				'name'  => 'panel_portfolio_single',
				'page'  => '_portfolio'
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_template',
				'type'          => 'select',
				'label'         => esc_html__( 'Portfolio Type', 'oaza-core' ),
				'default_value' => 'small-images',
				'description'   => esc_html__( 'Choose a default type for Single Project pages', 'oaza-core' ),
				'parent'        => $panel,
				'options'       => array(
					'huge-images'       => esc_html__( 'Portfolio Full Width Images', 'oaza-core' ),
					'images'            => esc_html__( 'Portfolio Images', 'oaza-core' ),
					'small-images'      => esc_html__( 'Portfolio Small Images', 'oaza-core' ),
					'slider'            => esc_html__( 'Portfolio Slider', 'oaza-core' ),
					'small-slider'      => esc_html__( 'Portfolio Small Slider', 'oaza-core' ),
					'gallery'           => esc_html__( 'Portfolio Gallery', 'oaza-core' ),
					'small-gallery'     => esc_html__( 'Portfolio Small Gallery', 'oaza-core' ),
					'masonry'           => esc_html__( 'Portfolio Masonry', 'oaza-core' ),
					'small-masonry'     => esc_html__( 'Portfolio Small Masonry', 'oaza-core' ),
					'custom'            => esc_html__( 'Portfolio Custom', 'oaza-core' ),
					'full-width-custom' => esc_html__( 'Portfolio Full Width Custom', 'oaza-core' )
				)
			)
		);
		
		/***************** Gallery Layout *****************/
		
		$portfolio_gallery_container = oaza_mikado_add_admin_container(
			array(
				'parent'          => $panel,
				'name'            => 'portfolio_gallery_container',
				'dependency' => array(
					'show' => array(
						'portfolio_single_template'  => array(
							'gallery',
							'small-gallery'
						)
					)
				)
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_gallery_columns_number',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'oaza-core' ),
				'default_value' => 'three',
				'description'   => esc_html__( 'Set number of columns for portfolio gallery type', 'oaza-core' ),
				'parent'        => $portfolio_gallery_container,
				'options'       => oaza_mikado_get_number_of_columns_array( false, array( 'one', 'five', 'six' ) )
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_gallery_space_between_items',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'oaza-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio gallery type', 'oaza-core' ),
				'default_value' => 'normal',
				'options'       => oaza_mikado_get_space_between_items_array(),
				'parent'        => $portfolio_gallery_container
			)
		);
		
		/***************** Gallery Layout *****************/
		
		/***************** Masonry Layout *****************/
		
		$portfolio_masonry_container = oaza_mikado_add_admin_container(
			array(
				'parent'          => $panel,
				'name'            => 'portfolio_masonry_container',
				'dependency' => array(
					'show' => array(
						'portfolio_single_template'  => array(
							'masonry',
							'small-masonry'
						)
					)
				)
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_masonry_columns_number',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'oaza-core' ),
				'default_value' => 'three',
				'description'   => esc_html__( 'Set number of columns for portfolio masonry type', 'oaza-core' ),
				'parent'        => $portfolio_masonry_container,
				'options'       => oaza_mikado_get_number_of_columns_array( false, array( 'one', 'five', 'six' ) )
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_masonry_space_between_items',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'oaza-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio masonry type', 'oaza-core' ),
				'default_value' => 'normal',
				'options'       => oaza_mikado_get_space_between_items_array(),
				'parent'        => $portfolio_masonry_container
			)
		);
		
		/***************** Masonry Layout *****************/
		
		oaza_mikado_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'show_title_area_portfolio_single',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'oaza-core' ),
				'description'   => esc_html__( 'Enabling this option will show title area on single projects', 'oaza-core' ),
				'parent'        => $panel,
				'options'       => array(
					''    => esc_html__( 'Default', 'oaza-core' ),
					'yes' => esc_html__( 'Yes', 'oaza-core' ),
					'no'  => esc_html__( 'No', 'oaza-core' )
				),
				'args'          => array(
					'col_width' => 3
				)
			)
		);

		oaza_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_related_posts',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Related Posts', 'oaza-core' ),
				'description'   => esc_html__( 'Enabling this option will turn on related posts for projects', 'oaza-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);

		oaza_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_lightbox_images',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Lightbox for Images', 'oaza-core' ),
				'description'   => esc_html__( 'Enabling this option will turn on lightbox functionality for projects with images', 'oaza-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_lightbox_videos',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Lightbox for Videos', 'oaza-core' ),
				'description'   => esc_html__( 'Enabling this option will turn on lightbox functionality for YouTube/Vimeo projects', 'oaza-core' ),
				'parent'        => $panel,
				'default_value' => 'no'
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_enable_categories',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Categories', 'oaza-core' ),
				'description'   => esc_html__( 'Enabling this option will enable category meta description on single projects', 'oaza-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_hide_date',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Date', 'oaza-core' ),
				'description'   => esc_html__( 'Enabling this option will enable date meta on single projects', 'oaza-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_sticky_sidebar',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Sticky Side Text', 'oaza-core' ),
				'description'   => esc_html__( 'Enabling this option will make side text sticky on Single Project pages. This option works only for Full Width Images, Small Images, Small Gallery and Small Masonry portfolio types', 'oaza-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_comments',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Show Comments', 'oaza-core' ),
				'description'   => esc_html__( 'Enabling this option will show comments on your page', 'oaza-core' ),
				'parent'        => $panel,
				'default_value' => 'no'
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_hide_pagination',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Hide Pagination', 'oaza-core' ),
				'description'   => esc_html__( 'Enabling this option will turn off portfolio pagination functionality', 'oaza-core' ),
				'parent'        => $panel,
				'default_value' => 'no'
			)
		);
		
		$container_navigate_category = oaza_mikado_add_admin_container(
			array(
				'name'            => 'navigate_same_category_container',
				'parent'          => $panel,
				'dependency' => array(
					'hide' => array(
						'portfolio_single_hide_pagination'  => array(
							'yes'
						)
					)
				)
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_nav_same_category',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Pagination Through Same Category', 'oaza-core' ),
				'description'   => esc_html__( 'Enabling this option will make portfolio pagination sort through current category', 'oaza-core' ),
				'parent'        => $container_navigate_category,
				'default_value' => 'no'
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'        => 'portfolio_single_slug',
				'type'        => 'text',
				'label'       => esc_html__( 'Portfolio Single Slug', 'oaza-core' ),
				'description' => esc_html__( 'Enter if you wish to use a different Single Project slug (Note: After entering slug, navigate to Settings -> Permalinks and click "Save" in order for changes to take effect)', 'oaza-core' ),
				'parent'      => $panel,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
	}
	
	add_action( 'oaza_mikado_action_options_map', 'oaza_mikado_portfolio_options_map', oaza_mikado_set_options_map_position( 'portfolio' ) );
}