<?php

if ( ! function_exists( 'oaza_core_map_testimonials_meta' ) ) {
	function oaza_core_map_testimonials_meta() {
		$testimonial_meta_box = oaza_mikado_create_meta_box(
			array(
				'scope' => array( 'testimonials' ),
				'title' => esc_html__( 'Testimonial', 'oaza-core' ),
				'name'  => 'testimonial_meta'
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_testimonial_title',
				'type'        => 'text',
				'label'       => esc_html__( 'Title', 'oaza-core' ),
				'description' => esc_html__( 'Enter testimonial title', 'oaza-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_testimonial_text',
				'type'        => 'text',
				'label'       => esc_html__( 'Text', 'oaza-core' ),
				'description' => esc_html__( 'Enter testimonial text', 'oaza-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_testimonial_author',
				'type'        => 'text',
				'label'       => esc_html__( 'Author', 'oaza-core' ),
				'description' => esc_html__( 'Enter author name', 'oaza-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_testimonial_author_position',
				'type'        => 'text',
				'label'       => esc_html__( 'Author Position', 'oaza-core' ),
				'description' => esc_html__( 'Enter author job position', 'oaza-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
	}
	
	add_action( 'oaza_mikado_action_meta_boxes_map', 'oaza_core_map_testimonials_meta', 95 );
}