<?php

if ( ! function_exists( 'oaza_core_reviews_map' ) ) {
	function oaza_core_reviews_map() {
		
		$reviews_panel = oaza_mikado_add_admin_panel(
			array(
				'title' => esc_html__( 'Reviews', 'oaza-core' ),
				'name'  => 'panel_reviews',
				'page'  => '_page_page'
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'parent'      => $reviews_panel,
				'type'        => 'text',
				'name'        => 'reviews_section_title',
				'label'       => esc_html__( 'Reviews Section Title', 'oaza-core' ),
				'description' => esc_html__( 'Enter title that you want to show before average rating on your page', 'oaza-core' ),
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'parent'      => $reviews_panel,
				'type'        => 'textarea',
				'name'        => 'reviews_section_subtitle',
				'label'       => esc_html__( 'Reviews Section Subtitle', 'oaza-core' ),
				'description' => esc_html__( 'Enter subtitle that you want to show before average rating on your page', 'oaza-core' ),
			)
		);
	}
	
	add_action( 'oaza_mikado_action_additional_page_options_map', 'oaza_core_reviews_map', 75 ); //one after elements
}