<?php

namespace OazaCore\CPT\Shortcodes\Counter;

use OazaCore\Lib;

class Counter implements Lib\ShortcodeInterface {
	private $base;
	
	public function __construct() {
		$this->base = 'mkdf_counter';
		
		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map(
				array(
					'name'                      => esc_html__( 'Counter', 'oaza-core' ),
					'base'                      => $this->getBase(),
					'category'                  => esc_html__( 'by OAZA', 'oaza-core' ),
					'icon'                      => 'icon-wpb-counter extended-custom-icon',
					'allowed_container_element' => 'vc_row',
					'params'                    => array_merge(
						array(
							array(
								'type'        => 'textfield',
								'param_name'  => 'custom_class',
								'heading'     => esc_html__( 'Custom CSS Class', 'oaza-core' ),
								'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'oaza-core' )
							),
							array(
								'type'        => 'dropdown',
								'param_name'  => 'type',
								'heading'     => esc_html__( 'Type', 'oaza-core' ),
								'value'       => array(
									esc_html__( 'Zero Counter', 'oaza-core' )   => 'mkdf-zero-counter',
									esc_html__( 'Random Counter', 'oaza-core' ) => 'mkdf-random-counter'
								),
								'save_always' => true,
							),
							array(
								'type'       => 'textfield',
								'param_name' => 'digit',
								'heading'    => esc_html__( 'Digit', 'oaza-core' )
							),
							array(
								'type'       => 'textfield',
								'param_name' => 'digit_font_size',
								'heading'    => esc_html__( 'Digit Font Size (px)', 'oaza-core' ),
								'dependency' => array( 'element' => 'digit', 'not_empty' => true )
							),
							array(
								'type'       => 'colorpicker',
								'param_name' => 'digit_color',
								'heading'    => esc_html__( 'Digit Color', 'oaza-core' ),
								'dependency' => array( 'element' => 'digit', 'not_empty' => true )
							),
							array(
								'type'       => 'textfield',
								'param_name' => 'digit_word',
								'heading'    => esc_html__( 'Digit Word', 'oaza-core' ),
								'dependency'  => array( 'element' => 'digit', 'not_empty' => true )
							),
							array(
								'type'       => 'textfield',
								'param_name' => 'digit_word_font_size',
								'heading'    => esc_html__( 'Digit Word Font Size (px)', 'oaza-core' ),
								'dependency' => array( 'element' => 'digit_word', 'not_empty' => true )
							),
							array(
								'type'       => 'colorpicker',
								'param_name' => 'digit_word_color',
								'heading'    => esc_html__( 'Digit Word Color', 'oaza-core' ),
								'dependency' => array( 'element' => 'digit_word', 'not_empty' => true )
							),
							array(
								'type'       => 'textfield',
								'param_name' => 'title',
								'heading'    => esc_html__( 'Digit Title', 'oaza-core' )
							),
							array(
								'type'        => 'dropdown',
								'param_name'  => 'title_tag',
								'heading'     => esc_html__( 'Digit Title Tag', 'oaza-core' ),
								'value'       => array_flip( oaza_mikado_get_title_tag( true ) ),
								'save_always' => true,
								'dependency'  => array( 'element' => 'title', 'not_empty' => true )
							),
							array(
								'type'       => 'colorpicker',
								'param_name' => 'title_color',
								'heading'    => esc_html__( 'Digit Title Color', 'oaza-core' ),
								'dependency' => array( 'element' => 'title', 'not_empty' => true )
							),
							array(
								'type'        => 'dropdown',
								'param_name'  => 'title_font_weight',
								'heading'     => esc_html__( 'Digit Title Font Weight', 'oaza-core' ),
								'value'       => array_flip( oaza_mikado_get_font_weight_array( true ) ),
								'save_always' => true,
								'dependency'  => array( 'element' => 'title', 'not_empty' => true )
							),
							array(
								'type'       => 'textarea',
								'param_name' => 'text',
								'heading'    => esc_html__( 'Text', 'oaza-core' )
							),
							array(
								'type'       => 'colorpicker',
								'param_name' => 'text_color',
								'heading'    => esc_html__( 'Text Color', 'oaza-core' ),
								'dependency' => array( 'element' => 'text', 'not_empty' => true )
							)
						),
						oaza_mikado_icon_collections()->getVCParamsArray( array(), '', true )
					)
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$args   = array(
			'custom_class'         => '',
			'type'                 => 'mkdf-zero-counter',
			'digit'                => '123',
			'digit_font_size'      => '',
			'digit_color'          => '',
			'digit_word'           => '',
			'digit_word_font_size' => '',
			'digit_word_color'     => '',
			'title'                => '',
			'title_tag'            => 'span',
			'title_color'          => '',
			'title_font_weight'    => '',
			'text'                 => '',
			'text_color'           => ''
		);
		$args   = array_merge( $args, oaza_mikado_icon_collections()->getShortcodeParams() );
		$params = shortcode_atts( $args, $atts );
		
		$iconPackName   = oaza_mikado_icon_collections()->getIconCollectionParamNameByKey( $params['icon_pack'] );
		$params['icon'] = $iconPackName ? $params[ $iconPackName ] : '';
		
		$params['holder_classes']       = $this->getHolderClasses( $params );
		$params['counter_styles']       = $this->getCounterStyles( $params );
		$params['counter_word_styles']  = $this->getCounterWordStyles( $params );
		$params['counter_title_styles'] = $this->getCounterTitleStyles( $params );
		$params['counter_text_styles']  = $this->getCounterTextStyles( $params );
		
		$params['title_tag'] = ! empty( $params['title_tag'] ) ? $params['title_tag'] : $args['title_tag'];

		$html = oaza_core_get_shortcode_module_template_part( 'templates/counter', 'counter', '', $params );
		
		return $html;
	}
	
	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		
		return implode( ' ', $holderClasses );
	}
	
	private function getCounterStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['digit_font_size'] ) ) {
			$styles[] = 'font-size: ' . oaza_mikado_filter_px( $params['digit_font_size'] ) . 'px';
		}
		
		if ( ! empty( $params['digit_color'] ) ) {
			$styles[] = 'color: ' . $params['digit_color'];
		}
		
		return implode( ';', $styles );
	}
	
	private function getCounterWordStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['digit_word_font_size'] ) ) {
			$styles[] = 'font-size: ' . oaza_mikado_filter_px( $params['digit_word_font_size'] ) . 'px';
		}
		
		if ( ! empty( $params['digit_word_color'] ) ) {
			$styles[] = 'color: ' . $params['digit_word_color'];
		}
		
		return implode( ';', $styles );
	}
	
	private function getCounterTitleStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['title_color'] ) ) {
			$styles[] = 'color: ' . $params['title_color'];
		}
		
		if ( ! empty( $params['title_font_weight'] ) ) {
			$styles[] = 'font-weight: ' . $params['title_font_weight'];
		}
		
		return implode( ';', $styles );
	}
	
	private function getCounterTextStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['text_color'] ) ) {
			$styles[] = 'color: ' . $params['text_color'];
		}
		
		return implode( ';', $styles );
	}
}