<?php
if(class_exists('OazaMikadoClassWidget')) {
	class OazaMikadoClassSeparatorWidget extends OazaMikadoClassWidget {
		public function __construct() {
			parent::__construct( 'mkdf_separator_widget', esc_html__( 'Oaza Separator Widget', 'oaza-core' ), array( 'description' => esc_html__( 'Add a separator element to your widget areas', 'oaza-core' ) ) );

			$this->setParams();
		}

		protected function setParams() {
			$this->params = array(
				array(
					'type'    => 'dropdown',
					'name'    => 'type',
					'title'   => esc_html__( 'Type', 'oaza-core' ),
					'options' => array(
						'normal'     => esc_html__( 'Normal', 'oaza-core' ),
						'full-width' => esc_html__( 'Full Width', 'oaza-core' )
					)
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'position',
					'title'   => esc_html__( 'Position', 'oaza-core' ),
					'options' => array(
						'center' => esc_html__( 'Center', 'oaza-core' ),
						'left'   => esc_html__( 'Left', 'oaza-core' ),
						'right'  => esc_html__( 'Right', 'oaza-core' )
					)
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'border_style',
					'title'   => esc_html__( 'Style', 'oaza-core' ),
					'options' => array(
						'solid'  => esc_html__( 'Solid', 'oaza-core' ),
						'dashed' => esc_html__( 'Dashed', 'oaza-core' ),
						'dotted' => esc_html__( 'Dotted', 'oaza-core' )
					)
				),
				array(
					'type'  => 'colorpicker',
					'name'  => 'color',
					'title' => esc_html__( 'Color', 'oaza-core' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'width',
					'title' => esc_html__( 'Width (px or %)', 'oaza-core' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'thickness',
					'title' => esc_html__( 'Thickness (px)', 'oaza-core' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'top_margin',
					'title' => esc_html__( 'Top Margin (px or %)', 'oaza-core' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'bottom_margin',
					'title' => esc_html__( 'Bottom Margin (px or %)', 'oaza-core' )
				)
			);
		}

		public function widget( $args, $instance ) {
			if ( ! is_array( $instance ) ) {
				$instance = array();
			}

			//prepare variables
			$params = '';

			//is instance empty?
			if ( is_array( $instance ) && count( $instance ) ) {
				//generate shortcode params
				foreach ( $instance as $key => $value ) {
					$params .= " $key='$value' ";
				}
			}

			echo '<div class="widget mkdf-separator-widget">';
			echo do_shortcode( "[mkdf_separator $params]" ); // XSS OK
			echo '</div>';
		}
	}
}