<?php

namespace OazaBusiness\Shortcodes\WorkingHours;

use OazaBusiness\Lib\ShortcodeInterface;

class WorkingHours implements ShortcodeInterface {
	private $base;

	public function __construct() {
		$this->base = 'mkdf_working_hours';

		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}

	public function getBase() {
		return $this->base;
	}

	public function vcMap() {
		vc_map(
			array(
				'name'     => esc_html__( 'Working Hours', 'oaza-business' ),
				'base'     => $this->base,
				'category' => esc_html__( 'by OAZA BUSINESS', 'oaza-business' ),
				'icon'     => 'icon-wpb-working-hours extended-custom-business-icon',
				'params'   => array(
					array(
						'type'        => 'textfield',
						'param_name'  => 'custom_class',
						'heading'     => esc_html__( 'Custom CSS Class', 'oaza-business' ),
						'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'oaza-business' )
					),
					array(
						'type'        => 'textfield',
						'param_name'  => 'title',
						'heading'     => esc_html__( 'Title', 'oaza-business' ),
						'admin_label' => true,
						'group'       => esc_html__( 'Styling Options', 'oaza-business' )
					),
					array(
						'type'        => 'dropdown',
						'param_name'  => 'title_tag',
						'heading'     => esc_html__( 'Title Tag', 'oaza-business' ),
						'value'       => array_flip( oaza_mikado_get_title_tag( true, array( 'p' => 'p' ) ) ),
						'save_always' => true,
						'dependency'  => array( 'element' => 'title', 'not_empty' => true ),
						'group'       => esc_html__( 'Styling Options', 'oaza-business' )
					),
					array(
						'type'       => 'colorpicker',
						'param_name' => 'title_color',
						'heading'    => esc_html__( 'Title Color', 'oaza-business' ),
						'dependency' => array( 'element' => 'title', 'not_empty' => true ),
						'group'      => esc_html__( 'Styling Options', 'oaza-business' )
					),
					array(
						'type'        => 'dropdown',
						'param_name'  => 'title_font_weight',
						'heading'     => esc_html__( 'Title Font Weight', 'oaza-business' ),
						'value'       => array_flip( oaza_mikado_get_font_weight_array( true ) ),
						'save_always' => true,
						'dependency'  => array( 'element' => 'title', 'not_empty' => true ),
						'group'       => esc_html__( 'Styling Options', 'oaza-business' )
					),
					array(
						'type'       => 'textfield',
						'param_name' => 'title_bottom_margin',
						'heading'    => esc_html__( 'Title Bottom Margin (px)', 'oaza-business' ),
						'dependency' => array( 'element' => 'title', 'not_empty' => true ),
						'group'      => esc_html__( 'Styling Options', 'oaza-business' )
					),
					array(
						'type'        => 'dropdown',
						'param_name'  => 'skin',
						'heading'     => esc_html__( 'Skin', 'oaza-business' ),
						'value'       => array_flip( oaza_business_get_business_shortcodes_skins() ),
						'save_always' => true
					),
					array(
						'type'        => 'dropdown',
						'param_name'  => 'label_tag',
						'heading'     => esc_html__( 'Label Tag', 'oaza-business' ),
						'value'       => array_flip( oaza_mikado_get_title_tag( true, array( 'p' => 'p' ) ) ),
						'save_always' => true,
						'std'         => 'h4',
						'group'       => esc_html__( 'Styling Options', 'oaza-business' )
					),
					array(
						'type'        => 'dropdown',
						'param_name'  => 'time_tag',
						'heading'     => esc_html__( 'Time Tag', 'oaza-business' ),
						'value'       => array_flip( oaza_mikado_get_title_tag( true, array( 'p' => 'p' ) ) ),
						'std'         => 'p',
						'save_always' => true,
						'group'       => esc_html__( 'Styling Options', 'oaza-business' )
					),
				)
			)
		);
	}

	public function render( $atts, $content = null ) {
		$args   = array(
			'custom_class'        => '',
			'title'               => '',
			'title_tag'           => 'h6',
			'title_color'         => '',
			'title_font_weight'   => '',
			'title_bottom_margin' => '',
			'label_tag'           => 'h5',
			'time_tag'            => 'p',
			'skin'                => ''
		);
		$params = shortcode_atts( $args, $atts );

		$params['holder_classes'] = $this->getHolderClasses( $params );
		$params['title_tag']      = ! empty( $params['title_tag'] ) ? $params['title_tag'] : $args['title_tag'];
		$params['title_styles']   = $this->getTitleStyles( $params );
		$params['working_hours']  = $this->getWorkingHours();

		return oaza_business_get_template_part( 'modules/shortcodes/working-hours/templates/working-hours-template', '', $params, true );
	}

	private function getWorkingHours() {
		$workingHours = array();

		if ( oaza_business_theme_installed() ) {
			switch ( oaza_mikado_options()->getOptionValue( 'working_hours_layout' ) ):

				////////////////////////////////////////////////////////////////////////////////////////////////////////
				case'workdays-weekend':
					// working days
					if ( oaza_mikado_options()->getOptionValue( 'wh_work_days_from' ) !== '' ) {
						$workingHours['work_days']['label'] = esc_html__('Working Days', 'mkdf-restaurant' );
						$workingHours['work_days']['from']  = oaza_mikado_options()->getOptionValue( 'wh_work_days_from' );
					}
					if ( oaza_mikado_options()->getOptionValue( 'wh_work_days_to' ) !== '' ) {
						$workingHours['work_days']['to'] = oaza_mikado_options()->getOptionValue( 'wh_work_days_to' );
					}

					// weekends
					if ( oaza_mikado_options()->getOptionValue( 'wh_weekend_from' ) !== '' ) {
						$workingHours['weekend']['label'] = esc_html__('Weekend', 'mkdf-restaurant' );
						$workingHours['weekend']['from']  = oaza_mikado_options()->getOptionValue( 'wh_weekend_from' );
					}
					if ( oaza_mikado_options()->getOptionValue( 'wh_weekend_to' ) !== '' ) {
						$workingHours['weekend']['to'] = oaza_mikado_options()->getOptionValue( 'wh_weekend_to' );
					}
					break;

				////////////////////////////////////////////////////////////////////////////////////////////////////////
				case'workdays-sat-sun':
					// working days
					if ( oaza_mikado_options()->getOptionValue( 'wh_work_days_from' ) !== '' ) {
						$workingHours['work_days']['label'] = esc_html__('Working Days', 'mkdf-restaurant' );
						$workingHours['work_days']['from']  = oaza_mikado_options()->getOptionValue( 'wh_work_days_from' );
					}
					if ( oaza_mikado_options()->getOptionValue( 'wh_work_days_to' ) !== '' ) {
						$workingHours['work_days']['to'] = oaza_mikado_options()->getOptionValue( 'wh_work_days_to' );
					}

					// saturday
					if ( oaza_mikado_options()->getOptionValue( 'wh_saturday_from' ) !== '' ) {
						$workingHours['saturday']['label'] = esc_html__('Saturday', 'mkdf-restaurant' );
						$workingHours['saturday']['from']  = oaza_mikado_options()->getOptionValue( 'wh_saturday_from' );
					}
					if ( oaza_mikado_options()->getOptionValue( 'wh_saturday_to' ) !== '' ) {
						$workingHours['saturday']['to'] = oaza_mikado_options()->getOptionValue( 'wh_saturday_to' );
					}

					// sunday
					if ( oaza_mikado_options()->getOptionValue( 'wh_sunday_from' ) !== '' ) {
						$workingHours['sunday']['label'] = esc_html__('Sunday', 'mkdf-restaurant' );
						$workingHours['sunday']['from']  = oaza_mikado_options()->getOptionValue( 'wh_sunday_from' );
					}
					if ( oaza_mikado_options()->getOptionValue( 'wh_sunday_to' ) !== '' ) {
						$workingHours['sunday']['to'] = oaza_mikado_options()->getOptionValue( 'wh_sunday_to' );
					}
					break;

				////////////////////////////////////////////////////////////////////////////////////////////////////////
				case'same':
					// same
					if ( oaza_mikado_options()->getOptionValue( 'wh_same_from' ) !== '' ) {
						$workingHours['same']['label'] = esc_html__('Every Day', 'mkdf-restaurant' );
						$workingHours['same']['from']  = oaza_mikado_options()->getOptionValue( 'wh_same_from' );
					}
					if ( oaza_mikado_options()->getOptionValue( 'wh_same_to' ) !== '' ) {
						$workingHours['same']['to'] = oaza_mikado_options()->getOptionValue( 'wh_same_to' );
					}
					break;

				////////////////////////////////////////////////////////////////////////////////////////////////////////
				case'mon-tue-wed-thu-fri-weekend':
					// monday
					if ( oaza_mikado_options()->getOptionValue( 'wh_monday_from' ) !== '' ) {
						$workingHours['monday']['label'] = esc_html__('Monday', 'mkdf-restaurant' );
						$workingHours['monday']['from']  = oaza_mikado_options()->getOptionValue( 'wh_monday_from' );
					}
					if ( oaza_mikado_options()->getOptionValue( 'wh_monday_to' ) !== '' ) {
						$workingHours['monday']['to'] = oaza_mikado_options()->getOptionValue( 'wh_monday_to' );
					}

					// tuesday
					if ( oaza_mikado_options()->getOptionValue( 'wh_tuesday_from' ) !== '' ) {
						$workingHours['tuesday']['label'] = esc_html__('Tuesday', 'mkdf-restaurant' );
						$workingHours['tuesday']['from']  = oaza_mikado_options()->getOptionValue( 'wh_tuesday_from' );
					}
					if ( oaza_mikado_options()->getOptionValue( 'wh_tuesday_to' ) !== '' ) {
						$workingHours['tuesday']['to'] = oaza_mikado_options()->getOptionValue( 'wh_tuesday_to' );
					}

					// wednesday
					if ( oaza_mikado_options()->getOptionValue( 'wh_wednesday_from' ) !== '' ) {
						$workingHours['wednesday']['label'] = esc_html__('Wednesday', 'mkdf-restaurant' );
						$workingHours['wednesday']['from']  = oaza_mikado_options()->getOptionValue( 'wh_wednesday_from' );
					}
					if ( oaza_mikado_options()->getOptionValue( 'wh_wednesday_to' ) !== '' ) {
						$workingHours['wednesday']['to'] = oaza_mikado_options()->getOptionValue( 'wh_wednesday_to' );
					}

					// thursday
					if ( oaza_mikado_options()->getOptionValue( 'wh_thursday_from' ) !== '' ) {
						$workingHours['thursday']['label'] = esc_html__('Thursday', 'mkdf-restaurant' );
						$workingHours['thursday']['from']  = oaza_mikado_options()->getOptionValue( 'wh_thursday_from' );
					}
					if ( oaza_mikado_options()->getOptionValue( 'wh_thursday_to' ) !== '' ) {
						$workingHours['thursday']['to'] = oaza_mikado_options()->getOptionValue( 'wh_thursday_to' );
					}

					// friday
					if ( oaza_mikado_options()->getOptionValue( 'wh_friday_from' ) !== '' ) {
						$workingHours['friday']['label'] = esc_html__('Friday', 'mkdf-restaurant' );
						$workingHours['friday']['from']  = oaza_mikado_options()->getOptionValue( 'wh_friday_from' );
					}
					if ( oaza_mikado_options()->getOptionValue( 'wh_friday_to' ) !== '' ) {
						$workingHours['friday']['to'] = oaza_mikado_options()->getOptionValue( 'wh_friday_to' );
					}

					// weekends
					if ( oaza_mikado_options()->getOptionValue( 'wh_weekend_from' ) !== '' ) {
						$workingHours['weekend']['label'] = esc_html__('Weekend', 'mkdf-restaurant' );
						$workingHours['weekend']['from']  = oaza_mikado_options()->getOptionValue( 'wh_weekend_from' );
					}
					if ( oaza_mikado_options()->getOptionValue( 'wh_weekend_to' ) !== '' ) {
						$workingHours['weekend']['to'] = oaza_mikado_options()->getOptionValue( 'wh_weekend_to' );
					}
					break;

				////////////////////////////////////////////////////////////////////////////////////////////////////////
				default:
					// monday
					if ( oaza_mikado_options()->getOptionValue( 'wh_monday_from' ) !== '' ) {
						$workingHours['monday']['label'] = esc_html__('Monday', 'mkdf-restaurant' );
						$workingHours['monday']['from']  = oaza_mikado_options()->getOptionValue( 'wh_monday_from' );
					}
					if ( oaza_mikado_options()->getOptionValue( 'wh_monday_to' ) !== '' ) {
						$workingHours['monday']['to'] = oaza_mikado_options()->getOptionValue( 'wh_monday_to' );
					}

					// tuesday
					if ( oaza_mikado_options()->getOptionValue( 'wh_tuesday_from' ) !== '' ) {
						$workingHours['tuesday']['label'] = esc_html__('Tuesday', 'mkdf-restaurant' );
						$workingHours['tuesday']['from']  = oaza_mikado_options()->getOptionValue( 'wh_tuesday_from' );
					}
					if ( oaza_mikado_options()->getOptionValue( 'wh_tuesday_to' ) !== '' ) {
						$workingHours['tuesday']['to'] = oaza_mikado_options()->getOptionValue( 'wh_tuesday_to' );
					}

					// wednesday
					if ( oaza_mikado_options()->getOptionValue( 'wh_wednesday_from' ) !== '' ) {
						$workingHours['wednesday']['label'] = esc_html__('Wednesday', 'mkdf-restaurant' );
						$workingHours['wednesday']['from']  = oaza_mikado_options()->getOptionValue( 'wh_wednesday_from' );
					}
					if ( oaza_mikado_options()->getOptionValue( 'wh_wednesday_to' ) !== '' ) {
						$workingHours['wednesday']['to'] = oaza_mikado_options()->getOptionValue( 'wh_wednesday_to' );
					}

					// thursday
					if ( oaza_mikado_options()->getOptionValue( 'wh_thursday_from' ) !== '' ) {
						$workingHours['thursday']['label'] = esc_html__('Thursday', 'mkdf-restaurant' );
						$workingHours['thursday']['from']  = oaza_mikado_options()->getOptionValue( 'wh_thursday_from' );
					}
					if ( oaza_mikado_options()->getOptionValue( 'wh_thursday_to' ) !== '' ) {
						$workingHours['thursday']['to'] = oaza_mikado_options()->getOptionValue( 'wh_thursday_to' );
					}

					// friday
					if ( oaza_mikado_options()->getOptionValue( 'wh_friday_from' ) !== '' ) {
						$workingHours['friday']['label'] = esc_html__('Friday', 'mkdf-restaurant' );
						$workingHours['friday']['from']  = oaza_mikado_options()->getOptionValue( 'wh_friday_from' );
					}
					if ( oaza_mikado_options()->getOptionValue( 'wh_friday_to' ) !== '' ) {
						$workingHours['friday']['to'] = oaza_mikado_options()->getOptionValue( 'wh_friday_to' );
					}

					// saturday
					if ( oaza_mikado_options()->getOptionValue( 'wh_saturday_from' ) !== '' ) {
						$workingHours['saturday']['label'] = esc_html__('Saturday', 'mkdf-restaurant' );
						$workingHours['saturday']['from']  = oaza_mikado_options()->getOptionValue( 'wh_saturday_from' );
					}
					if ( oaza_mikado_options()->getOptionValue( 'wh_saturday_to' ) !== '' ) {
						$workingHours['saturday']['to'] = oaza_mikado_options()->getOptionValue( 'wh_saturday_to' );
					}

					// sunday
					if ( oaza_mikado_options()->getOptionValue( 'wh_sunday_from' ) !== '' ) {
						$workingHours['sunday']['label'] = esc_html__('Sunday', 'mkdf-restaurant' );
						$workingHours['sunday']['from']  = oaza_mikado_options()->getOptionValue( 'wh_sunday_from' );
					}
					if ( oaza_mikado_options()->getOptionValue( 'wh_sunday_to' ) !== '' ) {
						$workingHours['sunday']['to'] = oaza_mikado_options()->getOptionValue( 'wh_sunday_to' );
					}
			endswitch;
		}

		return $workingHours;
	}

	private function getHolderClasses( $params ) {
		$classes = array();

		$classes[] = 'mkdf-wh-holder';
		$classes[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		$classes[] = ! empty( $params['skin'] ) ? 'mkdf-wh-' . $params['skin'] : '';

		return implode( ' ', array_filter( $classes ) );
	}

	private function getTitleStyles( $params ) {
		$styles = array();

		$styles[] = ! empty( $params['title_color'] ) ? 'color: ' . $params['title_color'] : '';
		$styles[] = ! empty( $params['title_font_weight'] ) ? 'font-weight: ' . $params['title_font_weight'] : '';
		$styles[] = ! empty( $params['title_bottom_margin'] ) ? 'margin-bottom: ' . oaza_mikado_filter_px( $params['title_bottom_margin'] ) . 'px' : '';

		return implode( ';', array_filter( $styles ) );
	}
}
