<?php

if ( ! function_exists( 'oaza_core_map_portfolio_settings_meta' ) ) {
	function oaza_core_map_portfolio_settings_meta() {
		$meta_box = oaza_mikado_create_meta_box( array(
			'scope' => 'portfolio-item',
			'title' => esc_html__( 'Portfolio Settings', 'oaza-core' ),
			'name'  => 'portfolio_settings_meta_box'
		) );
		
		oaza_mikado_create_meta_box_field( array(
			'name'        => 'mkdf_portfolio_single_template_meta',
			'type'        => 'select',
			'label'       => esc_html__( 'Portfolio Type', 'oaza-core' ),
			'description' => esc_html__( 'Choose a default type for Single Project pages', 'oaza-core' ),
			'parent'      => $meta_box,
			'options'     => array(
				''                  => esc_html__( 'Default', 'oaza-core' ),
				'huge-images'       => esc_html__( 'Portfolio Full Width Images', 'oaza-core' ),
				'images'            => esc_html__( 'Portfolio Images', 'oaza-core' ),
				'small-images'      => esc_html__( 'Portfolio Small Images', 'oaza-core' ),
				'slider'            => esc_html__( 'Portfolio Slider', 'oaza-core' ),
				'small-slider'      => esc_html__( 'Portfolio Small Slider', 'oaza-core' ),
				'gallery'           => esc_html__( 'Portfolio Gallery', 'oaza-core' ),
				'small-gallery'     => esc_html__( 'Portfolio Small Gallery', 'oaza-core' ),
				'masonry'           => esc_html__( 'Portfolio Masonry', 'oaza-core' ),
				'small-masonry'     => esc_html__( 'Portfolio Small Masonry', 'oaza-core' ),
				'custom'            => esc_html__( 'Portfolio Custom', 'oaza-core' ),
				'full-width-custom' => esc_html__( 'Portfolio Full Width Custom', 'oaza-core' )
			)
		) );
		
		/***************** Gallery Layout *****************/
		
		$gallery_type_meta_container = oaza_mikado_add_admin_container(
			array(
				'parent'          => $meta_box,
				'name'            => 'mkdf_gallery_type_meta_container',
				'dependency' => array(
					'show' => array(
						'mkdf_portfolio_single_template_meta'  => array(
							'gallery',
							'small-gallery'
						)
					)
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_portfolio_single_gallery_columns_number_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'oaza-core' ),
				'default_value' => '',
				'description'   => esc_html__( 'Set number of columns for portfolio gallery type', 'oaza-core' ),
				'parent'        => $gallery_type_meta_container,
				'options'       => oaza_mikado_get_number_of_columns_array( true, array( 'one', 'five', 'six' ) )
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_portfolio_single_gallery_space_between_items_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'oaza-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio gallery type', 'oaza-core' ),
				'default_value' => '',
				'options'       => oaza_mikado_get_space_between_items_array( true ),
				'parent'        => $gallery_type_meta_container
			)
		);
		
		/***************** Gallery Layout *****************/
		
		/***************** Masonry Layout *****************/
		
		$masonry_type_meta_container = oaza_mikado_add_admin_container(
			array(
				'parent'          => $meta_box,
				'name'            => 'mkdf_masonry_type_meta_container',
				'dependency' => array(
					'show' => array(
						'mkdf_portfolio_single_template_meta'  => array(
							'masonry',
							'small-masonry'
						)
					)
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_portfolio_single_masonry_columns_number_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'oaza-core' ),
				'default_value' => '',
				'description'   => esc_html__( 'Set number of columns for portfolio masonry type', 'oaza-core' ),
				'parent'        => $masonry_type_meta_container,
				'options'       => oaza_mikado_get_number_of_columns_array( true, array( 'one', 'five', 'six' ) )
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_portfolio_single_masonry_space_between_items_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'oaza-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio masonry type', 'oaza-core' ),
				'default_value' => '',
				'options'       => oaza_mikado_get_space_between_items_array( true ),
				'parent'        => $masonry_type_meta_container
			)
		);
		
		/***************** Masonry Layout *****************/
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_show_title_area_portfolio_single_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'oaza-core' ),
				'description'   => esc_html__( 'Enabling this option will show title area on your single portfolio page', 'oaza-core' ),
				'parent'        => $meta_box,
				'options'       => oaza_mikado_get_yes_no_select_array()
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'        => 'portfolio_info_top_padding',
				'type'        => 'text',
				'label'       => esc_html__( 'Portfolio Info Top Padding', 'oaza-core' ),
				'description' => esc_html__( 'Set top padding for portfolio info elements holder. This option works only for Portfolio Images, Slider, Gallery and Masonry portfolio types', 'oaza-core' ),
				'parent'      => $meta_box,
				'args'        => array(
					'col_width' => 3,
					'suffix'    => 'px'
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'        => 'portfolio_external_link',
				'type'        => 'text',
				'label'       => esc_html__( 'Portfolio External Link', 'oaza-core' ),
				'description' => esc_html__( 'Enter URL to link from Portfolio List page', 'oaza-core' ),
				'parent'      => $meta_box,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_portfolio_featured_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Featured Image', 'oaza-core' ),
				'description' => esc_html__( 'Choose an image for Portfolio Lists shortcode where Hover Type option is Switch Featured Images', 'oaza-core' ),
				'parent'      => $meta_box
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_portfolio_masonry_fixed_dimensions_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Dimensions for Masonry - Image Fixed Proportion', 'oaza-core' ),
				'description'   => esc_html__( 'Choose image layout when it appears in Masonry type portfolio lists where image proportion is fixed', 'oaza-core' ),
				'default_value' => '',
				'parent'        => $meta_box,
				'options'       => array(
					''                   => esc_html__( 'Default', 'oaza-core' ),
					'small'              => esc_html__( 'Small', 'oaza-core' ),
					'large-width'        => esc_html__( 'Large Width', 'oaza-core' ),
					'large-height'       => esc_html__( 'Large Height', 'oaza-core' ),
					'large-width-height' => esc_html__( 'Large Width/Height', 'oaza-core' )
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_portfolio_masonry_original_dimensions_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Dimensions for Masonry - Image Original Proportion', 'oaza-core' ),
				'description'   => esc_html__( 'Choose image layout when it appears in Masonry type portfolio lists where image proportion is original', 'oaza-core' ),
				'default_value' => '',
				'parent'        => $meta_box,
				'options'       => array(
					''            => esc_html__( 'Default', 'oaza-core' ),
					'large-width' => esc_html__( 'Large Width', 'oaza-core' )
				)
			)
		);
		
		$all_pages = array();
		$pages     = get_pages();
		foreach ( $pages as $page ) {
			$all_pages[ $page->ID ] = $page->post_title;
		}
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'        => 'portfolio_single_back_to_link',
				'type'        => 'select',
				'label'       => esc_html__( '"Back To" Link', 'oaza-core' ),
				'description' => esc_html__( 'Choose "Back To" page to link from portfolio Single Project page', 'oaza-core' ),
				'parent'      => $meta_box,
				'options'     => $all_pages,
				'args'        => array(
					'select2' => true
				)
			)
		);
	}
	
	add_action( 'oaza_mikado_action_meta_boxes_map', 'oaza_core_map_portfolio_settings_meta', 41 );
}