<?php
namespace OazaCore\CPT\Shortcodes\Billboard;

use OazaCore\Lib;

class Billboard implements Lib\ShortcodeInterface {
	private $base;
	
	public function __construct() {
		$this->base = 'mkdf_billboard';
		
		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map(
				array(
					'name'                      => esc_html__( 'Billboard', 'oaza-core' ),
					'base'                      => $this->getBase(),
					'category'                  => esc_html__( 'by OAZA', 'oaza-core' ),
					'icon'                      => 'icon-wpb-billboard extended-custom-icon',
					'allowed_container_element' => 'vc_row',
					'params'                    => array(
						array(
							'type'       => 'dropdown',
							'param_name' => 'orientation',
							'heading'    => esc_html__( 'Orientation', 'oaza-core' ),
							'value'      => array(
								esc_html__( 'Left', 'oaza-core' )  => 'left',
								esc_html__( 'Right', 'oaza-core' ) => 'right'
							)
						),
						array(
							'type'        => 'attach_image',
							'param_name'  => 'main_image',
							'heading'     => esc_html__( 'Main Image', 'oaza-core' ),
							'description' => esc_html__( 'Select image from media library', 'oaza-core' )
						),
						array(
							'type'        => 'attach_image',
							'param_name'  => 'additional_image',
							'heading'     => esc_html__( 'Additional Image', 'oaza-core' ),
							'description' => esc_html__( 'Select image from media library', 'oaza-core' )
						),
						array(
							'type'       => 'colorpicker',
							'param_name' => 'info_background_color',
							'heading'    => esc_html__( 'Info Background Color', 'oaza-core' )
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'tagline',
							'heading'     => esc_html__( 'Tagline', 'oaza-core' )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'tagline_bottom_margin',
							'heading'    => esc_html__( 'Tagline Bottom Margin (px)', 'oaza-core' ),
							'dependency' => array( 'element' => 'tagline', 'not_empty' => true )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'title',
							'heading'    => esc_html__( 'Title', 'oaza-core' )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'title_tag',
							'heading'     => esc_html__( 'Title Tag', 'oaza-core' ),
							'value'       => array_flip( oaza_mikado_get_title_tag( true, array( 'p' => 'p' ) ) ),
							'save_always' => true,
							'dependency'  => array( 'element' => 'title', 'not_empty' => true )
						),
						array(
							'type'       => 'textarea',
							'param_name' => 'description',
							'heading'    => esc_html__( 'Description', 'oaza-core' )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'description_top_margin',
							'heading'    => esc_html__( 'Description Top Margin (px)', 'oaza-core' ),
							'dependency' => array( 'element' => 'description', 'not_empty' => true )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'link',
							'heading'    => esc_html__( 'Link', 'oaza-core' )
						),
						array(
							'type'       => 'dropdown',
							'param_name' => 'target',
							'heading'    => esc_html__( 'Target', 'oaza-core' ),
							'value'      => array_flip( oaza_mikado_get_link_target_array() ),
							'dependency' => array( 'element' => 'link', 'not_empty' => true )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'link_text',
							'heading'    => esc_html__( 'Link Text', 'oaza-core' ),
							'dependency' => array( 'element' => 'link', 'not_empty' => true )
						),
						array(
							'type'       => 'dropdown',
							'param_name' => 'link_type',
							'heading'    => esc_html__( 'Link Type', 'oaza-core' ),
							'value'      => array(
								esc_html__( 'Outline', 'oaza-core' ) => 'outline',
								esc_html__( 'Solid', 'oaza-core' )   => 'solid',
								esc_html__( 'Simple', 'oaza-core' )  => 'simple'
							),
							'dependency' => array( 'element' => 'link', 'not_empty' => true )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'link_top_margin',
							'heading'    => esc_html__( 'Link Text Top Margin (px)', 'oaza-core' ),
							'dependency' => array( 'element' => 'link', 'not_empty' => true )
						)
					)
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$args   = array(
			'orientation'            => '',
			'main_image'             => '',
			'additional_image'       => '',
			'info_background_color'  => '',
			'tagline'                => '',
			'tagline_bottom_margin'  => '',
			'title'                  => '',
			'title_tag'              => 'h3',
			'description'            => '',
			'description_top_margin' => '',
			'link'                   => '',
			'target'                 => '_blank',
			'link_text'              => '',
			'link_type'              => 'outline',
			'link_top_margin'        => ''
		);
		$params = shortcode_atts( $args, $atts );

		$params['title_tag'] = ! empty( $params['title_tag'] ) ? $params['title_tag'] : $args['title_tag'];
		$params['target']    = ! empty( $params['target'] ) ? $params['target'] : $args['target'];
		$params['link_type'] = ! empty( $params['link_type'] ) ? $params['link_type'] : $args['link_type'];

		$params['holder_classes']               = $this->getHolderClasses( $params, $args );
		$params['main_section_bg_styles']       = $this->getBackgroundImageStyles( $params['main_image'] );
		$params['additional_section_bg_styles'] = $this->getBackgroundImageStyles( $params['additional_image'] );
		$params['info_styles']                  = $this->getInfoStyles( $params );
		$params['tagline_styles']               = $this->getTaglineStyles( $params );
		$params['description_styles']           = $this->getDescriptionStyles( $params );
		$params['button_styles']                = $this->getButtonStyles( $params );

		$html = oaza_core_get_shortcode_module_template_part( 'templates/billboard', 'billboard', '', $params );
		
		return $html;
	}

	private function getHolderClasses( $params, $args ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['orientation'] ) ? 'mkdf-billboard-' . $params['orientation'] . '-orientation' : '';

		return implode( ' ', $holderClasses );
	}

	private function getBackgroundImageStyles( $image ) {
		$styles = array();

		if ( ! empty( $image ) ) {
			$image_original = wp_get_attachment_image_src( $image, 'full' );

			$styles[] = 'background-image: url(' . $image_original[0] . ')';
			$styles[] = 'background-repeat: no-repeat';
            $styles[] = 'background-size: cover';
		}

		return implode( ';', $styles );
	}

	private function getInfoStyles( $params ) {
		$styles = array();

		if ( ! empty( $params['info_background_color'] ) ) {
			$styles[] = 'background-color: ' . $params['info_background_color'];
		}

		return implode( ';', $styles );
	}

	private function getTaglineStyles( $params ) {
		$styles = array();

		if ( ! empty( $params['tagline_bottom_margin'] ) ) {
			$styles[] = 'margin-bottom: ' . oaza_mikado_filter_px( $params['tagline_bottom_margin'] ) . 'px';
		}

		return implode( ';', $styles );
	}

	private function getDescriptionStyles( $params ) {
		$styles = array();

		if ( ! empty( $params['description_top_margin'] ) ) {
			$styles[] = 'margin-top: ' . oaza_mikado_filter_px( $params['description_top_margin'] ) . 'px';
		}

		return implode( ';', $styles );
	}

	private function getButtonStyles( $params ) {
		$styles = array();

		if ( ! empty( $params['link_top_margin'] ) ) {
			$styles[] = 'margin-top: ' . oaza_mikado_filter_px( $params['link_top_margin'] ) . 'px';
		}

		return implode( ';', $styles );
	}
}