<?php
namespace OazaCore\CPT\Shortcodes\LayoutHolder;

use OazaCore\Lib;

class LayoutHolder implements Lib\ShortcodeInterface {
	private $base;
	
	function __construct() {
		$this->base = 'mkdf_layout_holder';
		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map(
				array(
					'name'                    => esc_html__( 'Layout Holder', 'oaza-core' ),
					'base'                    => $this->base,
					'icon'                    => 'icon-wpb-layout-holder extended-custom-icon',
					'category'                => esc_html__( 'by OAZA', 'oaza-core' ),
					'as_parent'               => array( 'except' => 'vc_row, vc_accordion' ),
					'content_element'         => true,
					'show_settings_on_create' => true,
					'js_view'                 => 'VcColumnView',
					'params'    => array(
						array(
							'type'        => 'textfield',
							'param_name'  => 'custom_class',
							'heading'     => esc_html__( 'Custom CSS Class', 'oaza-core' ),
							'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'oaza-core' )
						),
						array(
							'type'       => 'colorpicker',
							'param_name' => 'background_color',
							'heading'    => esc_html__( 'Background Color', 'oaza-core' )
						),
						array(
							'type'        => 'attach_images',
							'param_name'  => 'images',
							'heading'     => esc_html__( 'Background Images', 'oaza-core' ),
							'description' => esc_html__( 'Select images from media library', 'oaza-core' )
						),
					)
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$args   = array(
			'custom_class'         => '',
			'background_color'     => '',
			'images'               => ''
		);
		$params = shortcode_atts( $args, $atts );

		$params['content']        = $content;
		$params['holder_classes'] = $this->getHolderClasses( $params );
		$params['holder_styles']  = $this->getHolderStyles( $params );
		$params['images']         = $this->prepareImages( $params );

		$html = oaza_core_get_shortcode_module_template_part( 'templates/layout-holder', 'layout-holder', '', $params );
		
		return $html;
	}
	
	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';

		return implode( ' ', $holderClasses );
	}
	
	private function getHolderStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['background_color'] ) ) {
			$styles[] = 'background-color: ' . $params['background_color'];
		}
		
		return implode( ';', $styles );
	}

	private function prepareImages( $params ) {
		$image_ids = array();
		$images    = array(
			'all'     => array(),
			'layouts' => array(
				'col_1' => array(),
				'col_2' => array()
			)
		);
		$i = 1;

		if ( $params['images'] !== '' ) {
			$image_ids = explode( ',', $params['images'] );
		}

		foreach ( $image_ids as $id ) {

			$image['image_id'] = $id;
			$image_original    = wp_get_attachment_image_src( $id, 'full' );
			$image['url']      = $image_original[0];
			$image['title']    = get_the_title( $id );
			$image['alt']      = get_post_meta( $id, '_wp_attachment_image_alt', true );

			$images[ 'all' ][] = $image;

			if ($i % 2 == 0) {
				$images[ 'layouts' ][ 'col_2' ][] = $image;
			} else {
				$images[ 'layouts' ][ 'col_1' ][] = $image;
			}


			$i++;
		}

		return $images;
	}
}
