<?php

if ( ! function_exists( 'oaza_mikado_get_hide_dep_for_top_header_options' ) ) {
	function oaza_mikado_get_hide_dep_for_top_header_options() {
		$hide_dep_options = apply_filters( 'oaza_mikado_filter_top_header_hide_global_option', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'oaza_mikado_header_top_options_map' ) ) {
	function oaza_mikado_header_top_options_map( $panel_header ) {
		$hide_dep_options = oaza_mikado_get_hide_dep_for_top_header_options();
		
		$top_header_container = oaza_mikado_add_admin_container_no_style(
			array(
				'type'            => 'container',
				'name'            => 'top_header_container',
				'parent'          => $panel_header,
				'dependency' => array(
					'hide' => array(
						'header_options'  => $hide_dep_options
					)
				)
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'          => 'top_bar',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Top Bar', 'oaza' ),
				'description'   => esc_html__( 'Enabling this option will show top bar area', 'oaza' ),
				'parent'        => $top_header_container,
			)
		);
		
		$top_bar_container = oaza_mikado_add_admin_container(
			array(
				'name'            => 'top_bar_container',
				'parent'          => $top_header_container,
				'dependency' => array(
					'hide' => array(
						'top_bar'  => 'no'
					)
				)
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'          => 'top_bar_in_grid',
				'type'          => 'yesno',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Top Bar in Grid', 'oaza' ),
				'description'   => esc_html__( 'Set top bar content to be in grid', 'oaza' ),
				'parent'        => $top_bar_container
			)
		);
		
		$top_bar_in_grid_container = oaza_mikado_add_admin_container(
			array(
				'name'            => 'top_bar_in_grid_container',
				'parent'          => $top_bar_container,
				'dependency' => array(
					'hide' => array(
						'top_bar_in_grid'  => 'no'
					)
				)
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'        => 'top_bar_grid_background_color',
				'type'        => 'color',
				'label'       => esc_html__( 'Grid Background Color', 'oaza' ),
				'description' => esc_html__( 'Set grid background color for top bar', 'oaza' ),
				'parent'      => $top_bar_in_grid_container
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'        => 'top_bar_grid_background_transparency',
				'type'        => 'text',
				'label'       => esc_html__( 'Grid Background Transparency', 'oaza' ),
				'description' => esc_html__( 'Set grid background transparency for top bar', 'oaza' ),
				'parent'      => $top_bar_in_grid_container,
				'args'        => array( 'col_width' => 3 )
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'        => 'top_bar_background_color',
				'type'        => 'color',
				'label'       => esc_html__( 'Background Color', 'oaza' ),
				'description' => esc_html__( 'Set background color for top bar', 'oaza' ),
				'parent'      => $top_bar_container
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'        => 'top_bar_background_transparency',
				'type'        => 'text',
				'label'       => esc_html__( 'Background Transparency', 'oaza' ),
				'description' => esc_html__( 'Set background transparency for top bar', 'oaza' ),
				'parent'      => $top_bar_container,
				'args'        => array( 'col_width' => 3 )
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'          => 'top_bar_border',
				'type'          => 'yesno',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Top Bar Border', 'oaza' ),
				'description'   => esc_html__( 'Set top bar border', 'oaza' ),
				'parent'        => $top_bar_container
			)
		);
		
		$top_bar_border_container = oaza_mikado_add_admin_container(
			array(
				'name'            => 'top_bar_border_container',
				'parent'          => $top_bar_container,
				'dependency' => array(
					'hide' => array(
						'top_bar_border'  => 'no'
					)
				)
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'        => 'top_bar_border_color',
				'type'        => 'color',
				'label'       => esc_html__( 'Top Bar Border Color', 'oaza' ),
				'description' => esc_html__( 'Choose color for top bar border', 'oaza' ),
				'parent'      => $top_bar_border_container
			)
		);

		oaza_mikado_add_admin_field(
			array(
				'name'        => 'top_bar_border_transparency',
				'type'        => 'text',
				'label'       => esc_html__( 'Top Bar Border Transparency', 'oaza' ),
				'description' => esc_html__( 'Set top bar border transparency. Value should be between 0 and 1', 'oaza' ),
				'parent'      => $top_bar_border_container,
				'args'        => array( 'col_width' => 3 )
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'        => 'top_bar_height',
				'type'        => 'text',
				'label'       => esc_html__( 'Top Bar Height', 'oaza' ),
				'description' => esc_html__( 'Enter top bar height (Default is 46px)', 'oaza' ),
				'parent'      => $top_bar_container,
				'args'        => array(
					'col_width' => 2,
					'suffix'    => 'px'
				)
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'   => 'top_bar_side_padding',
				'type'   => 'text',
				'label'  => esc_html__( 'Top Bar Side Padding', 'oaza' ),
				'parent' => $top_bar_container,
				'args'   => array(
					'col_width' => 2,
					'suffix'    => esc_html__( 'px or %', 'oaza' )
				)
			)
		);

		oaza_mikado_add_admin_field(
			array(
				'parent'        => $top_bar_container,
				'type'          => 'select',
				'name'          => 'top_bar_style',
				'default_value' => '',
				'label'         => esc_html__( 'Top Bar Skin', 'oaza' ),
				'description'   => esc_html__( 'Choose a predefined style for top bar', 'oaza' ),
				'options'       => array(
					''                 => esc_html__( 'Default', 'oaza' ),
					'light-header-top' => esc_html__( 'Light', 'oaza' ),
					'dark-header-top'  => esc_html__( 'Dark', 'oaza' )
				)
			)
		);
	}
	
	add_action( 'oaza_mikado_action_header_top_options_map', 'oaza_mikado_header_top_options_map', 10, 1 );
}