<?php

if ( ! function_exists( 'oaza_mikado_sidebar_options_map' ) ) {
	function oaza_mikado_sidebar_options_map() {
		
		oaza_mikado_add_admin_page(
			array(
				'slug'  => '_sidebar_page',
				'title' => esc_html__( 'Sidebar Area', 'oaza' ),
				'icon'  => 'fa fa-indent'
			)
		);
		
		$sidebar_panel = oaza_mikado_add_admin_panel(
			array(
				'title' => esc_html__( 'Sidebar Area', 'oaza' ),
				'name'  => 'sidebar',
				'page'  => '_sidebar_page'
			)
		);
		
		oaza_mikado_add_admin_field( array(
			'name'          => 'sidebar_layout',
			'type'          => 'select',
			'label'         => esc_html__( 'Sidebar Layout', 'oaza' ),
			'description'   => esc_html__( 'Choose a sidebar layout for pages', 'oaza' ),
			'parent'        => $sidebar_panel,
			'default_value' => 'no-sidebar',
            'options'       => oaza_mikado_get_custom_sidebars_options()
		) );
		
		$oaza_custom_sidebars = oaza_mikado_get_custom_sidebars();
		if ( count( $oaza_custom_sidebars ) > 0 ) {
			oaza_mikado_add_admin_field( array(
				'name'        => 'custom_sidebar_area',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Sidebar to Display', 'oaza' ),
				'description' => esc_html__( 'Choose a sidebar to display on pages. Default sidebar is "Sidebar"', 'oaza' ),
				'parent'      => $sidebar_panel,
				'options'     => $oaza_custom_sidebars,
				'args'        => array(
					'select2' => true
				)
			) );
		}
	}
	
	add_action( 'oaza_mikado_action_options_map', 'oaza_mikado_sidebar_options_map', oaza_mikado_set_options_map_position( 'sidebar' ) );
}