<?php

if ( ! function_exists( 'oaza_mikado_get_title_types_meta_boxes' ) ) {
	function oaza_mikado_get_title_types_meta_boxes() {
		$title_type_options = apply_filters( 'oaza_mikado_filter_title_type_meta_boxes', $title_type_options = array( '' => esc_html__( 'Default', 'oaza' ) ) );
		
		return $title_type_options;
	}
}

foreach ( glob( MIKADO_FRAMEWORK_MODULES_ROOT_DIR . '/title/types/*/admin/meta-boxes/*.php' ) as $meta_box_load ) {
	include_once $meta_box_load;
}

if ( ! function_exists( 'oaza_mikado_map_title_meta' ) ) {
	function oaza_mikado_map_title_meta() {
		$title_type_meta_boxes = oaza_mikado_get_title_types_meta_boxes();
		
		$title_meta_box = oaza_mikado_create_meta_box(
			array(
				'scope' => apply_filters( 'oaza_mikado_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'title_meta' ),
				'title' => esc_html__( 'Title', 'oaza' ),
				'name'  => 'title_meta'
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_show_title_area_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'oaza' ),
				'description'   => esc_html__( 'Disabling this option will turn off page title area', 'oaza' ),
				'parent'        => $title_meta_box,
				'options'       => oaza_mikado_get_yes_no_select_array()
			)
		);
		
			$show_title_area_meta_container = oaza_mikado_add_admin_container(
				array(
					'parent'          => $title_meta_box,
					'name'            => 'mkdf_show_title_area_meta_container',
					'dependency' => array(
						'hide' => array(
							'mkdf_show_title_area_meta' => 'no'
						)
					)
				)
			);
		
				oaza_mikado_create_meta_box_field(
					array(
						'name'          => 'mkdf_title_area_type_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Area Type', 'oaza' ),
						'description'   => esc_html__( 'Choose title type', 'oaza' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => $title_type_meta_boxes
					)
				);
		
				oaza_mikado_create_meta_box_field(
					array(
						'name'          => 'mkdf_title_area_in_grid_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Area In Grid', 'oaza' ),
						'description'   => esc_html__( 'Set title area content to be in grid', 'oaza' ),
						'options'       => oaza_mikado_get_yes_no_select_array(),
						'parent'        => $show_title_area_meta_container
					)
				);
		
				oaza_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_title_area_height_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Height', 'oaza' ),
						'description' => esc_html__( 'Set a height for Title Area', 'oaza' ),
						'parent'      => $show_title_area_meta_container,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px'
						)
					)
				);
				
				oaza_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_title_area_background_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Background Color', 'oaza' ),
						'description' => esc_html__( 'Choose a background color for title area', 'oaza' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
				oaza_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_title_area_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Image', 'oaza' ),
						'description' => esc_html__( 'Choose an Image for title area', 'oaza' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
				oaza_mikado_create_meta_box_field(
					array(
						'name'          => 'mkdf_title_area_background_image_behavior_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Background Image Behavior', 'oaza' ),
						'description'   => esc_html__( 'Choose title area background image behavior', 'oaza' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							''                    => esc_html__( 'Default', 'oaza' ),
							'hide'                => esc_html__( 'Hide Image', 'oaza' ),
							'responsive'          => esc_html__( 'Enable Responsive Image', 'oaza' ),
							'responsive-disabled' => esc_html__( 'Disable Responsive Image', 'oaza' ),
							'parallax'            => esc_html__( 'Enable Parallax Image', 'oaza' ),
							'parallax-zoom-out'   => esc_html__( 'Enable Parallax With Zoom Out Image', 'oaza' ),
							'parallax-disabled'   => esc_html__( 'Disable Parallax Image', 'oaza' )
						)
					)
				);
				
				oaza_mikado_create_meta_box_field(
					array(
						'name'          => 'mkdf_title_area_vertical_alignment_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Vertical Alignment', 'oaza' ),
						'description'   => esc_html__( 'Specify title area content vertical alignment', 'oaza' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							''              => esc_html__( 'Default', 'oaza' ),
							'header-bottom' => esc_html__( 'From Bottom of Header', 'oaza' ),
							'window-top'    => esc_html__( 'From Window Top', 'oaza' )
						)
					)
				);
				
				oaza_mikado_create_meta_box_field(
					array(
						'name'          => 'mkdf_title_area_title_tag_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Tag', 'oaza' ),
						'options'       => oaza_mikado_get_title_tag( true ),
						'parent'        => $show_title_area_meta_container
					)
				);
				
				oaza_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_title_text_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Title Color', 'oaza' ),
						'description' => esc_html__( 'Choose a color for title text', 'oaza' ),
						'parent'      => $show_title_area_meta_container
					)
				);
				
				oaza_mikado_create_meta_box_field(
					array(
						'name'          => 'mkdf_title_area_subtitle_meta',
						'type'          => 'text',
						'default_value' => '',
						'label'         => esc_html__( 'Subtitle Text', 'oaza' ),
						'description'   => esc_html__( 'Enter your subtitle text', 'oaza' ),
						'parent'        => $show_title_area_meta_container,
						'args'          => array(
							'col_width' => 6
						)
					)
				);
		
				oaza_mikado_create_meta_box_field(
					array(
						'name'          => 'mkdf_title_area_subtitle_tag_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Subtitle Tag', 'oaza' ),
						'options'       => oaza_mikado_get_title_tag( true, array( 'p' => 'p' ) ),
						'parent'        => $show_title_area_meta_container
					)
				);
				
				oaza_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_subtitle_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Subtitle Color', 'oaza' ),
						'description' => esc_html__( 'Choose a color for subtitle text', 'oaza' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
		/***************** Additional Title Area Layout - start *****************/
		
		do_action( 'oaza_mikado_action_additional_title_area_meta_boxes', $show_title_area_meta_container );
		
		/***************** Additional Title Area Layout - end *****************/
		
	}
	
	add_action( 'oaza_mikado_action_meta_boxes_map', 'oaza_mikado_map_title_meta', 60 );
}