<?php

if ( ! function_exists( 'oaza_business_activation' ) ) {
	/**
	 * Triggers when plugin is activated. It calls flush_rewrite_rules
	 * and defines oaza_business_on_activate action
	 */
	function oaza_business_activation() {
		do_action( 'oaza_business_on_activate' );
		
		// OazaBusiness\PostTypesRegister::getInstance()->register();
		flush_rewrite_rules();
	}
	
	register_activation_hook( __FILE__, 'oaza_business_activation' );
}

if ( ! function_exists( 'oaza_business_text_domain' ) ) {
	/**
	 * Loads plugin text domain so it can be used in translation
	 */
	function oaza_business_text_domain() {
		load_plugin_textdomain( 'oaza-business', false, OAZA_BUSINESS_REL_PATH . '/languages' );
	}
	
	add_action( 'plugins_loaded', 'oaza_business_text_domain' );
}

if ( ! function_exists( 'oaza_business_version_class' ) ) {
	/**
	 * Adds plugins version class to body
	 *
	 * @param $classes
	 *
	 * @return array
	 */
	function oaza_business_version_class( $classes ) {
		$classes[] = 'mkdf-business-' . OAZA_BUSINESS_VERSION;
		
		return $classes;
	}
	
	add_filter( 'body_class', 'oaza_business_version_class' );
}

if ( ! function_exists( 'oaza_business_theme_installed' ) ) {
	/**
	 * Checks whether theme is installed or not
	 * @return bool
	 */
	function oaza_business_theme_installed() {
		return defined( 'MIKADO_ROOT' );
	}
}

if ( ! function_exists( 'oaza_business_get_shortcode_module_template_part' ) ) {
	/**
	 * Loads module template part.
	 *
	 * @param string $post_type name of the post type folder
	 * @param string $shortcode name of the shortcode folder
	 * @param string $template name of the template to load
	 * @param string $slug
	 * @param array  $params array of parameters to pass to template
	 *
	 * @return html
	 */
	function oaza_business_get_shortcode_module_template_part( $post_type, $shortcode, $template, $slug = '', $params = array() ) {
		
		//HTML Content from template
		$html          = '';
		$template_path = OAZA_BUSINESS_CPT_PATH . '/' . $post_type . '/shortcodes/' . $shortcode . '/templates';
		
		$temp = $template_path . '/' . $template;
		if ( is_array( $params ) && count( $params ) ) {
			extract( $params );
		}
		
		$template = '';
		
		if ( $temp !== '' ) {
			$template = $temp . '.php';
			
			if ( $slug !== '' ) {
				$template = "{$temp}-{$slug}.php";
			}
		}
		if ( $template ) {
			ob_start();
			include( $template );
			$html = ob_get_clean();
		}
		
		return $html;
	}
}

if ( ! function_exists( 'oaza_business_get_template_part' ) ) {
	/**
	 * Loads template part with parameters. If file with slug parameter added exists it will load that file, else it will load file without slug added.
	 * Child theme friendly function
	 *
	 * @param string $template name of the template to load without extension
	 * @param string $slug
	 * @param array  $params array of parameters to pass to template
	 * @param bool   $return whether to return it as a string
	 *
	 * @return mixed
	 */
	function oaza_business_get_template_part( $template, $slug = '', $params = array(), $return = false ) {
		//HTML Content from template
		$html          = '';
		$template_path = OAZA_BUSINESS_ABS_PATH;
		
		$temp = $template_path . '/' . $template;
		if ( is_array( $params ) && count( $params ) ) {
			extract( $params );
		}
		
		$template = '';
		
		if ( $temp !== '' ) {
			$template = $temp . '.php';
			
			if ( $slug !== '' ) {
				$template = "{$temp}-{$slug}.php";
			}
		}
		
		if ( $template ) {
			if ( $return ) {
				ob_start();
			}
			
			include( $template );
			
			if ( $return ) {
				$html = ob_get_clean();
			}
			
		}
		
		if ( $return ) {
			return $html;
		}
	}
}

if ( ! function_exists( 'oaza_business_is_wpml_installed' ) ) {
	/**
	 * Function that checks if WPML plugin is installed
	 * @return bool
	 *
	 * @version 0.1
	 */
	function oaza_business_is_wpml_installed() {
		return defined( 'ICL_SITEPRESS_VERSION' );
	}
}

if ( ! function_exists( 'oaza_business_get_booked_shortcodes_types' ) ) {
	/**
	 * Get value array for visual composer shortcodes
	 *
	 * @return array
	 */
	function oaza_business_get_booked_shortcodes_types() {
		$types = array(
			'calendar' => esc_html__( 'Calendar', 'oaza-business' ),
			'list'     => esc_html__( 'List', 'oaza-business' ),
		);
		
		return $types;
	}
}

if ( ! function_exists( 'oaza_business_get_business_shortcodes_skins' ) ) {
	/**
	 * Get value array for visual composer shortcodes
	 *
	 * @return array
	 */
	function oaza_business_get_business_shortcodes_skins() {
		$skins = array(
			''      => esc_html__( 'Default', 'oaza-business' ),
			'light' => esc_html__( 'Light', 'oaza-business' ),
			'dark'  => esc_html__( 'Dark', 'oaza-business' ),
		);
		
		return $skins;
	}
}

if ( ! function_exists( 'oaza_business_is_booked_calendar_installed' ) ) {
	/**
	 * Function that checks if Booked plugin is installed
	 * @return bool
	 *
	 * @version 0.1
	 */
	function oaza_business_is_booked_calendar_installed() {
		return defined( 'BOOKED_VERSION' );
	}
}