<?php

if ( ! function_exists( 'oaza_mikado_content_bottom_options_map' ) ) {
	function oaza_mikado_content_bottom_options_map() {
		
		$panel_content_bottom = oaza_mikado_add_admin_panel(
			array(
				'page'  => '_page_page',
				'name'  => 'panel_content_bottom',
				'title' => esc_html__( 'Content Bottom Area Style', 'oaza' )
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'name'          => 'enable_content_bottom_area',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Content Bottom Area', 'oaza' ),
				'description'   => esc_html__( 'This option will enable Content Bottom area on pages', 'oaza' ),
				'parent'        => $panel_content_bottom
			)
		);
		
		$enable_content_bottom_area_container = oaza_mikado_add_admin_container(
			array(
				'parent'          => $panel_content_bottom,
				'name'            => 'enable_content_bottom_area_container',
				'dependency' => array(
					'show' => array(
						'enable_content_bottom_area'  => 'yes'
					)
				)
			)
		);
		
		$oaza_custom_sidebars = oaza_mikado_get_custom_sidebars();
		
		oaza_mikado_add_admin_field(
			array(
				'type'          => 'selectblank',
				'name'          => 'content_bottom_sidebar_custom_display',
				'default_value' => '',
				'label'         => esc_html__( 'Widget Area to Display', 'oaza' ),
				'description'   => esc_html__( 'Choose a Content Bottom widget area to display', 'oaza' ),
				'options'       => $oaza_custom_sidebars,
				'parent'        => $enable_content_bottom_area_container
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'content_bottom_in_grid',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Display in Grid', 'oaza' ),
				'description'   => esc_html__( 'Enabling this option will place Content Bottom in grid', 'oaza' ),
				'parent'        => $enable_content_bottom_area_container
			)
		);
		
		oaza_mikado_add_admin_field(
			array(
				'type'        => 'color',
				'name'        => 'content_bottom_background_color',
				'label'       => esc_html__( 'Background Color', 'oaza' ),
				'description' => esc_html__( 'Choose a background color for Content Bottom area', 'oaza' ),
				'parent'      => $enable_content_bottom_area_container
			)
		);
	}
	
	add_action( 'oaza_mikado_action_additional_page_options_map', 'oaza_mikado_content_bottom_options_map' );
}