<?php

if ( ! function_exists( 'oaza_mikado_get_hide_dep_for_header_standard_meta_boxes' ) ) {
	function oaza_mikado_get_hide_dep_for_header_standard_meta_boxes() {
		$hide_dep_options = apply_filters( 'oaza_mikado_filter_header_standard_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'oaza_mikado_header_standard_meta_map' ) ) {
	function oaza_mikado_header_standard_meta_map( $parent ) {
		$hide_dep_options = oaza_mikado_get_hide_dep_for_header_standard_meta_boxes();
		
		oaza_mikado_create_meta_box_field(
			array(
				'parent'          => $parent,
				'type'            => 'select',
				'name'            => 'mkdf_set_menu_area_position_meta',
				'default_value'   => '',
				'label'           => esc_html__( 'Choose Menu Area Position', 'oaza' ),
				'description'     => esc_html__( 'Select menu area position in your header', 'oaza' ),
				'options'         => array(
					''       => esc_html__( 'Default', 'oaza' ),
					'left'   => esc_html__( 'Left', 'oaza' ),
					'right'  => esc_html__( 'Right', 'oaza' ),
					'center' => esc_html__( 'Center', 'oaza' )
				),
				'dependency' => array(
					'hide' => array(
						'mkdf_header_type_meta'  => $hide_dep_options
					)
				)
			)
		);
	}
	
	add_action( 'oaza_mikado_action_additional_header_area_meta_boxes_map', 'oaza_mikado_header_standard_meta_map' );
}