<?php

/**
 * Force Visual Composer to initialize as "built into the theme". This will hide certain tabs under the Settings->Visual Composer page
 */
if ( function_exists( 'vc_set_as_theme' ) ) {
	vc_set_as_theme( true );
}

/**
 * Change path for overridden templates
 */
if ( function_exists( 'vc_set_shortcodes_templates_dir' ) ) {
	$dir = MIKADO_ROOT_DIR . '/vc-templates';
	vc_set_shortcodes_templates_dir( $dir );
}

if ( ! function_exists( 'oaza_mikado_configure_visual_composer_frontend_editor' ) ) {
	/**
	 * Configuration for Visual Composer FrontEnd Editor
	 * Hooks on vc_after_init action
	 */
	function oaza_mikado_configure_visual_composer_frontend_editor() {
		/**
		 * Remove frontend editor
		 */
		if ( function_exists( 'vc_disable_frontend' ) ) {
			vc_disable_frontend();
		}
	}
	
	add_action( 'vc_after_init', 'oaza_mikado_configure_visual_composer_frontend_editor' );
}

if ( ! function_exists( 'oaza_mikado_vc_row_map' ) ) {
	/**
	 * Map VC Row shortcode
	 * Hooks on vc_after_init action
	 */
	function oaza_mikado_vc_row_map() {
		
		/******* VC Row shortcode - begin *******/
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'dropdown',
				'param_name' => 'row_content_width',
				'heading'    => esc_html__( 'Mikado Row Content Width', 'oaza' ),
				'value'      => array(
					esc_html__( 'Full Width', 'oaza' ) => 'full-width',
					esc_html__( 'In Grid', 'oaza' )    => 'grid'
				),
				'group'      => esc_html__( 'Mikado Settings', 'oaza' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'textfield',
				'param_name'  => 'anchor',
				'heading'     => esc_html__( 'Mikado Anchor ID', 'oaza' ),
				'description' => esc_html__( 'For example "home"', 'oaza' ),
				'group'       => esc_html__( 'Mikado Settings', 'oaza' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'colorpicker',
				'param_name' => 'simple_background_color',
				'heading'    => esc_html__( 'Mikado Background Color', 'oaza' ),
				'group'      => esc_html__( 'Mikado Settings', 'oaza' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'attach_image',
				'param_name' => 'simple_background_image',
				'heading'    => esc_html__( 'Mikado Background Image', 'oaza' ),
				'group'      => esc_html__( 'Mikado Settings', 'oaza' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'textfield',
				'param_name'  => 'background_image_position',
				'heading'     => esc_html__( 'Mikado Background Position', 'oaza' ),
				'description' => esc_html__( 'Set the starting position of a background image, default value is top left', 'oaza' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Mikado Settings', 'oaza' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'dropdown',
				'param_name'  => 'disable_background_image',
				'heading'     => esc_html__( 'Mikado Disable Background Image', 'oaza' ),
				'value'       => array(
					esc_html__( 'Never', 'oaza' )        => '',
					esc_html__( 'Below 1280px', 'oaza' ) => '1280',
					esc_html__( 'Below 1024px', 'oaza' ) => '1024',
					esc_html__( 'Below 768px', 'oaza' )  => '768',
					esc_html__( 'Below 680px', 'oaza' )  => '680',
					esc_html__( 'Below 480px', 'oaza' )  => '480'
				),
				'save_always' => true,
				'description' => esc_html__( 'Choose on which stage you hide row background image', 'oaza' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Mikado Settings', 'oaza' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'attach_image',
				'param_name' => 'parallax_background_image',
				'heading'    => esc_html__( 'Mikado Parallax Background Image', 'oaza' ),
				'group'      => esc_html__( 'Mikado Settings', 'oaza' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'textfield',
				'param_name'  => 'parallax_bg_speed',
				'heading'     => esc_html__( 'Mikado Parallax Speed', 'oaza' ),
				'description' => esc_html__( 'Set your parallax speed. Default value is 1.', 'oaza' ),
				'dependency'  => array( 'element' => 'parallax_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Mikado Settings', 'oaza' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'textfield',
				'param_name' => 'parallax_bg_height',
				'heading'    => esc_html__( 'Mikado Parallax Section Height (px)', 'oaza' ),
				'dependency' => array( 'element' => 'parallax_background_image', 'not_empty' => true ),
				'group'      => esc_html__( 'Mikado Settings', 'oaza' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'dropdown',
				'param_name' => 'content_text_aligment',
				'heading'    => esc_html__( 'Mikado Content Aligment', 'oaza' ),
				'value'      => array(
					esc_html__( 'Default', 'oaza' ) => '',
					esc_html__( 'Left', 'oaza' )    => 'left',
					esc_html__( 'Center', 'oaza' )  => 'center',
					esc_html__( 'Right', 'oaza' )   => 'right'
				),
				'group'      => esc_html__( 'Mikado Settings', 'oaza' )
			)
		);

		vc_add_param( 'vc_row',
			array(
				'type'       => 'dropdown',
				'param_name' => 'enable_row_shadow',
				'heading'    => esc_html__( 'Mikado Enable Row Shadow', 'oaza' ),
				'value'      => array_flip( oaza_mikado_get_yes_no_select_array( false ) ),
				'group'      => esc_html__( 'Mikado Settings', 'oaza' )
			)
		);

		do_action( 'oaza_mikado_action_additional_vc_row_params' );
		
		/******* VC Row shortcode - end *******/
		
		/******* VC Row Inner shortcode - begin *******/
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'dropdown',
				'param_name' => 'row_content_width',
				'heading'    => esc_html__( 'Mikado Row Content Width', 'oaza' ),
				'value'      => array(
					esc_html__( 'Full Width', 'oaza' ) => 'full-width',
					esc_html__( 'In Grid', 'oaza' )    => 'grid'
				),
				'group'      => esc_html__( 'Mikado Settings', 'oaza' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'colorpicker',
				'param_name' => 'simple_background_color',
				'heading'    => esc_html__( 'Mikado Background Color', 'oaza' ),
				'group'      => esc_html__( 'Mikado Settings', 'oaza' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'attach_image',
				'param_name' => 'simple_background_image',
				'heading'    => esc_html__( 'Mikado Background Image', 'oaza' ),
				'group'      => esc_html__( 'Mikado Settings', 'oaza' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'        => 'textfield',
				'param_name'  => 'background_image_position',
				'heading'     => esc_html__( 'Mikado Background Position', 'oaza' ),
				'description' => esc_html__( 'Set the starting position of a background image, default value is top left', 'oaza' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Mikado Settings', 'oaza' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'        => 'dropdown',
				'param_name'  => 'disable_background_image',
				'heading'     => esc_html__( 'Mikado Disable Background Image', 'oaza' ),
				'value'       => array(
					esc_html__( 'Never', 'oaza' )        => '',
					esc_html__( 'Below 1280px', 'oaza' ) => '1280',
					esc_html__( 'Below 1024px', 'oaza' ) => '1024',
					esc_html__( 'Below 768px', 'oaza' )  => '768',
					esc_html__( 'Below 680px', 'oaza' )  => '680',
					esc_html__( 'Below 480px', 'oaza' )  => '480'
				),
				'save_always' => true,
				'description' => esc_html__( 'Choose on which stage you hide row background image', 'oaza' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Mikado Settings', 'oaza' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'dropdown',
				'param_name' => 'content_text_aligment',
				'heading'    => esc_html__( 'Mikado Content Aligment', 'oaza' ),
				'value'      => array(
					esc_html__( 'Default', 'oaza' ) => '',
					esc_html__( 'Left', 'oaza' )    => 'left',
					esc_html__( 'Center', 'oaza' )  => 'center',
					esc_html__( 'Right', 'oaza' )   => 'right'
				),
				'group'      => esc_html__( 'Mikado Settings', 'oaza' )
			)
		);

		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'dropdown',
				'param_name' => 'enable_row_shadow',
				'heading'    => esc_html__( 'Mikado Enable Row Shadow', 'oaza' ),
				'value'      => array_flip( oaza_mikado_get_yes_no_select_array( false ) ),
				'group'      => esc_html__( 'Mikado Settings', 'oaza' )
			)
		);
		
		/******* VC Row Inner shortcode - end *******/
		
		/******* VC Revolution Slider shortcode - begin *******/
		
		if ( oaza_mikado_is_plugin_installed( 'revolution-slider' ) ) {
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'enable_paspartu',
					'heading'     => esc_html__( 'Mikado Enable Passepartout', 'oaza' ),
					'value'       => array_flip( oaza_mikado_get_yes_no_select_array( false ) ),
					'save_always' => true,
					'group'       => esc_html__( 'Mikado Settings', 'oaza' )
				)
			);
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'paspartu_size',
					'heading'     => esc_html__( 'Mikado Passepartout Size', 'oaza' ),
					'value'       => array(
						esc_html__( 'Tiny', 'oaza' )   => 'tiny',
						esc_html__( 'Small', 'oaza' )  => 'small',
						esc_html__( 'Normal', 'oaza' ) => 'normal',
						esc_html__( 'Large', 'oaza' )  => 'large'
					),
					'save_always' => true,
					'dependency'  => array( 'element' => 'enable_paspartu', 'value' => array( 'yes' ) ),
					'group'       => esc_html__( 'Mikado Settings', 'oaza' )
				)
			);
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'disable_side_paspartu',
					'heading'     => esc_html__( 'Mikado Disable Side Passepartout', 'oaza' ),
					'value'       => array_flip( oaza_mikado_get_yes_no_select_array( false ) ),
					'save_always' => true,
					'dependency'  => array( 'element' => 'enable_paspartu', 'value' => array( 'yes' ) ),
					'group'       => esc_html__( 'Mikado Settings', 'oaza' )
				)
			);
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'disable_top_paspartu',
					'heading'     => esc_html__( 'Mikado Disable Top Passepartout', 'oaza' ),
					'value'       => array_flip( oaza_mikado_get_yes_no_select_array( false ) ),
					'save_always' => true,
					'dependency'  => array( 'element' => 'enable_paspartu', 'value' => array( 'yes' ) ),
					'group'       => esc_html__( 'Mikado Settings', 'oaza' )
				)
			);
		}
		
		/******* VC Revolution Slider shortcode - end *******/
	}
	
	add_action( 'vc_after_init', 'oaza_mikado_vc_row_map' );
}