<?php
namespace OazaBusiness\Shortcodes\BookedCalendar;

use OazaBusiness\Lib\ShortcodeInterface;

class BookedCalendar implements ShortcodeInterface
{
    private $base;

    public function __construct() {
        $this->base = 'mkdf_booked_calendar';

        add_action('vc_before_init', array($this, 'vcMap'));
    }

    public function getBase() {
        return $this->base;
    }

    public function vcMap() {
        vc_map(array(
            'name' => esc_html__('Booked Calendar', 'oaza-business'),
            'base' => $this->base,
            'category' => esc_html__('by OAZA BUSINESS', 'oaza-business'),
            'icon' => 'icon-wpb-booked-calendar extended-custom-business-icon',
            'params' => array(
                array(
                    'type' => 'textfield',
                    'param_name' => 'custom_class',
                    'heading' => esc_html__('Custom CSS Class', 'oaza-business'),
                    'description' => esc_html__('Style particular content element differently - add a class name and refer to it in custom CSS', 'oaza-business')
                ),
                array(
                    'type' => 'dropdown',
                    'param_name' => 'calendar',
                    'heading' => esc_html__('Calendar', 'oaza-business'),
                    'value' => array_flip(oaza_business_get_booked_calendar_array()),
                    'save_always' => true
                ),
                array(
                    'type' => 'dropdown',
                    'param_name' => 'calendar_size',
                    'heading' => esc_html__('Calendar Size', 'oaza-business'),
                    'value' => array(
                        esc_html__('Large', 'oaza-business') => 'large',
                        esc_html__('Small', 'oaza-business') => 'small'
                    ),
                    'save_always' => true
                ),
                array(
                    'type' => 'textfield',
                    'param_name' => 'title',
                    'heading' => esc_html__('Title', 'oaza-business'),
                    'admin_label' => true,
                ),
                array(
                    'type' => 'dropdown',
                    'param_name' => 'title_tag',
                    'heading' => esc_html__('Title Tag', 'oaza-business'),
                    'value' => array_flip(oaza_mikado_get_title_tag(true, array('p' => 'p'))),
                    'save_always' => true,
                    'dependency' => array('element' => 'title', 'not_empty' => true)
                ),
                array(
                    'type' => 'colorpicker',
                    'param_name' => 'title_color',
                    'heading' => esc_html__('Title Color', 'oaza-business'),
                    'dependency' => array('element' => 'title', 'not_empty' => true)
                ),
                array(
                    'type' => 'dropdown',
                    'param_name' => 'title_font_weight',
                    'heading' => esc_html__('Title Font Weight', 'oaza-business'),
                    'value' => array_flip(oaza_mikado_get_font_weight_array(true)),
                    'save_always' => true,
                    'dependency' => array('element' => 'title', 'not_empty' => true)
                ),
                array(
                    'type' => 'textfield',
                    'param_name' => 'title_bottom_margin',
                    'heading' => esc_html__('Title Bottom Margin (px)', 'oaza-business'),
                    'dependency' => array('element' => 'title', 'not_empty' => true)
                )
            )
        ));
    }

    public function render($atts, $content = null) {
        $args = array(
	        'custom_class'        => '',
	        'calendar'            => '',
	        'calendar_size'       => 'large',
	        'calendar_style'      => 'calendar',
	        'title'               => '',
	        'title_tag'           => 'h6',
	        'title_color'         => '',
	        'title_color'         => '',
	        'title_font_weight'   => '',
	        'title_bottom_margin' => ''
        );

        $params = shortcode_atts($args, $atts);

        $params['holder_classes'] = $this->getHolderClasses($params);
        $params['title_tag'] = !empty($params['title_tag']) ? $params['title_tag'] : $args['title_tag'];
        $params['title_styles'] = $this->getTitleStyles($params);
        $params['content'] = $content;
        $params['calendar_attrs'] = $this->getCalendarAttributes($params);

        return oaza_business_get_template_part('modules/shortcodes/booked-calendar/templates/booked-calendar-template', '', $params, true);
    }

    private function getHolderClasses($params) {
        $classes = array();

        $classes[] = 'mkdf-booked-calendar';
        $classes[] = !empty($params['custom_class']) ? esc_attr($params['custom_class']) : '';

        // @see http://php.net/manual/en/function.array-filter.php
        return implode(' ', array_filter($classes));
    }

    private function getTitleStyles($params) {
        $styles = array();

        $styles[] = !empty($params['title_color']) ? 'color: ' . $params['title_color'] : '';
        $styles[] = !empty($params['title_font_weight']) ? 'font-weight: ' . $params['title_font_weight'] : '';
        $styles[] = !empty($params['title_bottom_margin']) ? 'margin-bottom: ' . oaza_mikado_filter_px($params['title_bottom_margin']) . 'px' : '';

        // @see http://php.net/manual/en/function.array-filter.php
        return implode(';', array_filter($styles));
    }

    private function getCalendarAttributes($params) {
        $attrs = array();

        $attrs[] = !empty($params['calendar']) ? 'calendar="' . esc_attr($params['calendar']) . '"' : '';
        $attrs[] = !empty($params['calendar_size']) ? 'size="' . esc_attr($params['calendar_size']) . '"' : '';
        $attrs[] = !empty($params['calendar_style']) ? 'style="' . esc_attr($params['calendar_style']) . '"' : '';

        // @see http://php.net/manual/en/function.array-filter.php
        return implode(' ', array_filter($attrs));
    }
}