<?php

if ( class_exists( 'OazaMikadoClassWidget' ) ) {
	class OazaBusinessPhpClassWorkingHours extends OazaMikadoClassWidget {
		public function __construct() {
			parent::__construct(
				'oaza_business_working_hours',
				esc_html__( 'Oaza Working Hours', 'oaza-business' ),
				array( 'description' => esc_html__( 'Add Working Hours to widget areas', 'oaza-business' ) )
			);
			
			$this->setParams();
		}
		
		protected function setParams() {
			$this->params = array(
				array(
					'type'  => 'textfield',
					'name'  => 'extra_class',
					'title' => esc_html__( 'Extra Class Name', 'oaza-business' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'widget_title',
					'title' => esc_html__( 'Widget Title', 'oaza-business' )
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'label_tag',
					'title'   => esc_html__( 'Label Tag', 'oaza-business' ),
					'options' => oaza_mikado_get_title_tag( true, array( 'p' => 'p' ) )
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'time_tag',
					'title'   => esc_html__( 'Time Tag', 'oaza-business' ),
					'options' => oaza_mikado_get_title_tag( true, array( 'p' => 'p' ) )
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'skin',
					'title'   => esc_html__( 'Skin', 'oaza-business' ),
					'options' => oaza_business_get_business_shortcodes_skins()
				)
			);
		}
		
		public function widget( $args, $instance ) {
			$extra_class = ! empty( $instance['extra_class'] ) ? esc_attr( $instance['extra_class'] ) : '';
			if ( empty( $instance['label_tag'] ) ) {
				$instance['label_tag'] = 'h5';
			}
			if ( empty( $instance['time_tag'] ) ) {
				$instance['time_tag'] = 'p';
			}
			?>
			
			<div class="widget mkdf-working-hours-widget <?php echo esc_attr( $extra_class ); ?>">
				<?php if ( ! empty( $instance['widget_title'] ) ) {
					echo wp_kses_post( $args['before_title'] ) . esc_html( $instance['widget_title'] ) . wp_kses_post( $args['after_title'] );
				}
				echo do_shortcode( '[mkdf_working_hours label_tag="' . esc_attr( $instance['label_tag'] ) . '" time_tag="' . esc_attr( $instance['time_tag'] ) . '" skin="' . esc_attr( $instance['skin'] ) . '"]' );
				?>
			</div>
		<?php }
	}
}