(function ($) {
	'use strict';
	
	var fullScreenImageSlider = {};
	mkdf.modules.fullScreenImageSlider = fullScreenImageSlider;
	
	
	fullScreenImageSlider.mkdfOnWindowLoad = mkdfOnWindowLoad;
	
	$(window).load(mkdfOnWindowLoad);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function mkdfOnWindowLoad() {
		mkdfInitFullScreenImageSlider();
	}
	
	/**
	 * Init Full Screen Image Slider Shortcode
	 */
	function mkdfInitFullScreenImageSlider() {
		var holder = $('.mkdf-fsis-slider');
		
		if (holder.length) {
			holder.each(function () {
				var sliderHolder = $(this),
					mainHolder = sliderHolder.parent(),
					prevThumbNav = mainHolder.children('.mkdf-fsis-prev-nav'),
					nextThumbNav = mainHolder.children('.mkdf-fsis-next-nav'),
					maskHolder = mainHolder.children('.mkdf-fsis-slider-mask');
				
				mainHolder.addClass('mkdf-fsis-is-init');
				
				mkdfImageBehavior(sliderHolder);
				mkdfPrevNextImageBehavior(sliderHolder, prevThumbNav, nextThumbNav, -1); // -1 is arbitrary value because 0 can be index of item
				
				sliderHolder.on('drag.owl.carousel', function () {
					setTimeout(function () {
						if (!maskHolder.hasClass('mkdf-drag') && !mainHolder.hasClass('mkdf-fsis-active')) {
							maskHolder.addClass('mkdf-drag');
						}
					}, 200);
				});
				
				sliderHolder.on('dragged.owl.carousel', function () {
					setTimeout(function () {
						if (maskHolder.hasClass('mkdf-drag')) {
							maskHolder.removeClass('mkdf-drag');
						}
					}, 300);
				});
				
				sliderHolder.on('translate.owl.carousel', function (e) {
					mkdfPrevNextImageBehavior(sliderHolder, prevThumbNav, nextThumbNav, e.item.index);
				});
				
				sliderHolder.on('translated.owl.carousel', function () {
					mkdfImageBehavior(sliderHolder);
					
					setTimeout(function () {
						maskHolder.removeClass('mkdf-drag');
					}, 300);
				});
			});
		}
	}
	
	function mkdfImageBehavior(sliderHolder) {
		var activeItem = sliderHolder.find('.owl-item.active'),
			imageHolder = sliderHolder.find('.mkdf-fsis-item');
		
		imageHolder.removeClass('mkdf-fsis-content-image-init');
		
		mkdfResetImageBehavior(sliderHolder);
		
		if (activeItem.length) {
			var activeImageHolder = activeItem.find('.mkdf-fsis-item'),
				activeItemImage = activeImageHolder.children('.mkdf-fsis-image');
			
			setTimeout(function () {
				activeImageHolder.addClass('mkdf-fsis-content-image-init');
			}, 100);
			
			activeItemImage.off().on('mouseenter', function () {
				activeImageHolder.addClass('mkdf-fsis-image-hover');
			}).on('mouseleave', function () {
				activeImageHolder.removeClass('mkdf-fsis-image-hover');
			}).on('click', function () {
				if (activeImageHolder.hasClass('mkdf-fsis-active-image')) {
					sliderHolder.trigger('play.owl.autoplay');
					sliderHolder.parent().removeClass('mkdf-fsis-active');
					activeImageHolder.removeClass('mkdf-fsis-active-image');
				} else {
					sliderHolder.trigger('stop.owl.autoplay');
					sliderHolder.parent().addClass('mkdf-fsis-active');
					activeImageHolder.addClass('mkdf-fsis-active-image');
				}
			});
			
			//Close on escape
			$(document).keyup(function (e) {
				if (e.keyCode === 27) { //KeyCode for ESC button is 27
					sliderHolder.trigger('play.owl.autoplay');
					sliderHolder.parent().removeClass('mkdf-fsis-active');
					activeImageHolder.removeClass('mkdf-fsis-active-image');
				}
			});
		}
	}
	
	function mkdfPrevNextImageBehavior(sliderHolder, prevThumbNav, nextThumbNav, itemIndex) {
		var activeItem = itemIndex === -1 ? sliderHolder.find('.owl-item.active') : $(sliderHolder.find('.owl-item')[itemIndex]),
			prevItemImage = activeItem.prev().find('.mkdf-fsis-image').css('background-image'),
			nextItemImage = activeItem.next().find('.mkdf-fsis-image').css('background-image');
		
		if (prevItemImage.length) {
			prevThumbNav.css({'background-image': prevItemImage});
		}
		
		if (nextItemImage.length) {
			nextThumbNav.css({'background-image': nextItemImage});
		}
	}
	
	function mkdfResetImageBehavior(sliderHolder) {
		var imageHolder = sliderHolder.find('.mkdf-fsis-item');
		
		if (imageHolder.length) {
			imageHolder.removeClass('mkdf-fsis-active-image');
		}
	}
	
})(jQuery);