<?php
if(class_exists('OazaMikadoClassWidget')) {
	class OazaMikadoClassButtonWidget extends OazaMikadoClassWidget {
		public function __construct() {
			parent::__construct( 'mkdf_button_widget', esc_html__( 'Oaza Button Widget', 'oaza-core' ), array( 'description' => esc_html__( 'Add button element to widget areas', 'oaza-core' ) ) );

			$this->setParams();
		}

		protected function setParams() {
			$this->params = array(
				array(
					'type'    => 'dropdown',
					'name'    => 'type',
					'title'   => esc_html__( 'Type', 'oaza-core' ),
					'options' => array(
						'solid'   => esc_html__( 'Solid', 'oaza-core' ),
						'outline' => esc_html__( 'Outline', 'oaza-core' ),
						'simple'  => esc_html__( 'Simple', 'oaza-core' )
					)
				),
				array(
					'type'        => 'dropdown',
					'name'        => 'size',
					'title'       => esc_html__( 'Size', 'oaza-core' ),
					'options'     => array(
						'small'  => esc_html__( 'Small', 'oaza-core' ),
						'medium' => esc_html__( 'Medium', 'oaza-core' ),
						'large'  => esc_html__( 'Large', 'oaza-core' ),
						'huge'   => esc_html__( 'Huge', 'oaza-core' )
					),
					'description' => esc_html__( 'This option is only available for solid and outline button type', 'oaza-core' )
				),
				array(
					'type'    => 'textfield',
					'name'    => 'text',
					'title'   => esc_html__( 'Text', 'oaza-core' ),
					'default' => esc_html__( 'Button Text', 'oaza-core' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'link',
					'title' => esc_html__( 'Link', 'oaza-core' )
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'target',
					'title'   => esc_html__( 'Link Target', 'oaza-core' ),
					'options' => oaza_mikado_get_link_target_array()
				),
				array(
					'type'  => 'colorpicker',
					'name'  => 'color',
					'title' => esc_html__( 'Color', 'oaza-core' )
				),
				array(
					'type'  => 'colorpicker',
					'name'  => 'hover_color',
					'title' => esc_html__( 'Hover Color', 'oaza-core' )
				),
				array(
					'type'        => 'colorpicker',
					'name'        => 'background_color',
					'title'       => esc_html__( 'Background Color', 'oaza-core' ),
					'description' => esc_html__( 'This option is only available for solid button type', 'oaza-core' )
				),
				array(
					'type'        => 'colorpicker',
					'name'        => 'hover_background_color',
					'title'       => esc_html__( 'Hover Background Color', 'oaza-core' ),
					'description' => esc_html__( 'This option is only available for solid button type', 'oaza-core' )
				),
				array(
					'type'        => 'colorpicker',
					'name'        => 'border_color',
					'title'       => esc_html__( 'Border Color', 'oaza-core' ),
					'description' => esc_html__( 'This option is only available for solid and outline button type', 'oaza-core' )
				),
				array(
					'type'        => 'colorpicker',
					'name'        => 'hover_border_color',
					'title'       => esc_html__( 'Hover Border Color', 'oaza-core' ),
					'description' => esc_html__( 'This option is only available for solid and outline button type', 'oaza-core' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'font_size',
					'title' => esc_html__( 'Font Size (px)', 'oaza-core' )
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'font_weight',
					'title'   => esc_html__( 'Font Weight', 'oaza-core' ),
					'options' => oaza_mikado_get_font_weight_array( true )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'letter_spacing',
					'title' => esc_html__( 'Letter Spacing (px)', 'oaza-core' )
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'text_transform',
					'title'   => esc_html__( 'Text Transform', 'oaza-core' ),
					'options' => oaza_mikado_get_text_transform_array( true )
				),
				array(
					'type'        => 'textfield',
					'name'        => 'margin',
					'title'       => esc_html__( 'Margin', 'oaza-core' ),
					'description' => esc_html__( 'Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'oaza-core' )
				)
			);
		}

		public function widget( $args, $instance ) {
			$params = '';

			if ( ! is_array( $instance ) ) {
				$instance = array();
			}

			// Filter out all empty params
			$instance = array_filter( $instance, function ( $array_value ) {
				return trim( $array_value ) != '';
			} );

			// Default values
			if ( ! isset( $instance['text'] ) ) {
				$instance['text'] = 'Button Text';
			}

			// Generate shortcode params
			foreach ( $instance as $key => $value ) {
				$params .= " $key='$value' ";
			}

			echo '<div class="widget mkdf-button-widget">';
			echo do_shortcode( "[mkdf_button $params]" ); // XSS OK
			echo '</div>';
		}
	}
}