<?php

if ( ! function_exists( 'oaza_mikado_map_post_video_meta' ) ) {
	function oaza_mikado_map_post_video_meta() {
		$video_post_format_meta_box = oaza_mikado_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Video Post Format', 'oaza' ),
				'name'  => 'post_format_video_meta'
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_video_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Video Type', 'oaza' ),
				'description'   => esc_html__( 'Choose video type', 'oaza' ),
				'parent'        => $video_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Video Service', 'oaza' ),
					'self'            => esc_html__( 'Self Hosted', 'oaza' )
				)
			)
		);
		
		$mkdf_video_embedded_container = oaza_mikado_add_admin_container(
			array(
				'parent' => $video_post_format_meta_box,
				'name'   => 'mkdf_video_embedded_container'
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_post_video_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video URL', 'oaza' ),
				'description' => esc_html__( 'Enter Video URL', 'oaza' ),
				'parent'      => $mkdf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'mkdf_video_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_post_video_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video MP4', 'oaza' ),
				'description' => esc_html__( 'Enter video URL for MP4 format', 'oaza' ),
				'parent'      => $mkdf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'mkdf_video_type_meta' => 'self'
					)
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_post_video_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Video Image', 'oaza' ),
				'description' => esc_html__( 'Enter video image', 'oaza' ),
				'parent'      => $mkdf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'mkdf_video_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'oaza_mikado_action_meta_boxes_map', 'oaza_mikado_map_post_video_meta', 22 );
}