<?php

if ( ! function_exists( 'oaza_mikado_footer_options_map' ) ) {
	function oaza_mikado_footer_options_map() {

		oaza_mikado_add_admin_page(
			array(
				'slug'  => '_footer_page',
				'title' => esc_html__( 'Footer', 'oaza' ),
				'icon'  => 'fa fa-sort-amount-asc'
			)
		);

		$footer_panel = oaza_mikado_add_admin_panel(
			array(
				'title' => esc_html__( 'Footer', 'oaza' ),
				'name'  => 'footer',
				'page'  => '_footer_page'
			)
		);

		oaza_mikado_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'footer_in_grid',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Footer in Grid', 'oaza' ),
				'description'   => esc_html__( 'Enabling this option will place Footer content in grid', 'oaza' ),
				'parent'        => $footer_panel
			)
		);

        oaza_mikado_add_admin_field(
            array(
                'type'          => 'yesno',
                'name'          => 'uncovering_footer',
                'default_value' => 'no',
                'label'         => esc_html__( 'Uncovering Footer', 'oaza' ),
                'description'   => esc_html__( 'Enabling this option will make Footer gradually appear on scroll', 'oaza' ),
                'parent'        => $footer_panel
            )
        );

		oaza_mikado_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_top',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Top', 'oaza' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Top area', 'oaza' ),
				'parent'        => $footer_panel
			)
		);
		
		$show_footer_top_container = oaza_mikado_add_admin_container(
			array(
				'name'       => 'show_footer_top_container',
				'parent'     => $footer_panel,
				'dependency' => array(
					'show' => array(
						'show_footer_top' => 'yes'
					)
				)
			)
		);

		oaza_mikado_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns',
				'parent'        => $show_footer_top_container,
				'default_value' => '3 3 3 3',
				'label'         => esc_html__( 'Footer Top Columns', 'oaza' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Top area', 'oaza' ),
				'options'       => array(
					'12' => '1',
					'6 6' => '2',
					'4 4 4' => '3',
                    '3 3 6' => '3 (25% + 25% + 50%)',
					'3 3 3 3' => '4'
				)
			)
		);

		oaza_mikado_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns_alignment',
				'default_value' => 'left',
				'label'         => esc_html__( 'Footer Top Columns Alignment', 'oaza' ),
				'description'   => esc_html__( 'Text Alignment in Footer Columns', 'oaza' ),
				'options'       => array(
					''       => esc_html__( 'Default', 'oaza' ),
					'left'   => esc_html__( 'Left', 'oaza' ),
					'center' => esc_html__( 'Center', 'oaza' ),
					'right'  => esc_html__( 'Right', 'oaza' )
				),
				'parent'        => $show_footer_top_container
			)
		);
		
		$footer_top_styles_group = oaza_mikado_add_admin_group(
			array(
				'name'        => 'footer_top_styles_group',
				'title'       => esc_html__( 'Footer Top Styles', 'oaza' ),
				'description' => esc_html__( 'Define style for footer top area', 'oaza' ),
				'parent'      => $show_footer_top_container
			)
		);
		
		$footer_top_styles_row_1 = oaza_mikado_add_admin_row(
			array(
				'name'   => 'footer_top_styles_row_1',
				'parent' => $footer_top_styles_group
			)
		);
		
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'footer_top_background_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Background Color', 'oaza' ),
					'parent' => $footer_top_styles_row_1
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'footer_top_border_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Border Color', 'oaza' ),
					'parent' => $footer_top_styles_row_1
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'footer_top_border_width',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'Border Width', 'oaza' ),
					'parent' => $footer_top_styles_row_1,
					'args'   => array(
						'suffix' => 'px'
					)
				)
			);

		oaza_mikado_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_bottom',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Bottom', 'oaza' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Bottom area', 'oaza' ),
				'parent'        => $footer_panel
			)
		);

		$show_footer_bottom_container = oaza_mikado_add_admin_container(
			array(
				'name'            => 'show_footer_bottom_container',
				'parent'          => $footer_panel,
				'dependency' => array(
					'show' => array(
						'show_footer_bottom'  => 'yes'
					)
				)
			)
		);

		oaza_mikado_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_bottom_columns',
				'default_value' => '6 6',
				'label'         => esc_html__( 'Footer Bottom Columns', 'oaza' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Bottom area', 'oaza' ),
				'options'       => array(
					'12' => '1',
					'6 6' => '2',
					'4 4 4' => '3'
				),
				'parent'        => $show_footer_bottom_container
			)
		);
		
		$footer_bottom_styles_group = oaza_mikado_add_admin_group(
			array(
				'name'        => 'footer_bottom_styles_group',
				'title'       => esc_html__( 'Footer Bottom Styles', 'oaza' ),
				'description' => esc_html__( 'Define style for footer bottom area', 'oaza' ),
				'parent'      => $show_footer_bottom_container
			)
		);
		
		$footer_bottom_styles_row_1 = oaza_mikado_add_admin_row(
			array(
				'name'   => 'footer_bottom_styles_row_1',
				'parent' => $footer_bottom_styles_group
			)
		);
		
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'footer_bottom_background_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Background Color', 'oaza' ),
					'parent' => $footer_bottom_styles_row_1
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'footer_bottom_border_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Border Color', 'oaza' ),
					'parent' => $footer_bottom_styles_row_1
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'footer_bottom_border_width',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'Border Width', 'oaza' ),
					'parent' => $footer_bottom_styles_row_1,
					'args'   => array(
						'suffix' => 'px'
					)
				)
			);
	}

	add_action( 'oaza_mikado_action_options_map', 'oaza_mikado_footer_options_map', oaza_mikado_set_options_map_position( 'footer' ) );
}