<?php

if ( ! function_exists( 'oaza_mikado_map_sidebar_meta' ) ) {
	function oaza_mikado_map_sidebar_meta() {
		$mkdf_sidebar_meta_box = oaza_mikado_create_meta_box(
			array(
				'scope' => apply_filters( 'oaza_mikado_filter_set_scope_for_meta_boxes', array( 'page' ), 'sidebar_meta' ),
				'title' => esc_html__( 'Sidebar', 'oaza' ),
				'name'  => 'sidebar_meta'
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_sidebar_layout_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Sidebar Layout', 'oaza' ),
				'description' => esc_html__( 'Choose the sidebar layout', 'oaza' ),
				'parent'      => $mkdf_sidebar_meta_box,
                'options'       => oaza_mikado_get_custom_sidebars_options( true )
			)
		);
		
		$mkdf_custom_sidebars = oaza_mikado_get_custom_sidebars();
		if ( count( $mkdf_custom_sidebars ) > 0 ) {
			oaza_mikado_create_meta_box_field(
				array(
					'name'        => 'mkdf_custom_sidebar_area_meta',
					'type'        => 'selectblank',
					'label'       => esc_html__( 'Choose Widget Area in Sidebar', 'oaza' ),
					'description' => esc_html__( 'Choose Custom Widget area to display in Sidebar"', 'oaza' ),
					'parent'      => $mkdf_sidebar_meta_box,
					'options'     => $mkdf_custom_sidebars,
					'args'        => array(
						'select2' => true
					)
				)
			);
		}
	}
	
	add_action( 'oaza_mikado_action_meta_boxes_map', 'oaza_mikado_map_sidebar_meta', 31 );
}