<?php
namespace OazaCore\CPT\Shortcodes\Banner;

use OazaCore\Lib;

class Banner implements Lib\ShortcodeInterface {
	private $base;
	
	public function __construct() {
		$this->base = 'mkdf_banner';
		
		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map(
				array(
					'name'                      => esc_html__( 'Banner', 'oaza-core' ),
					'base'                      => $this->getBase(),
					'category'                  => esc_html__( 'by OAZA', 'oaza-core' ),
					'icon'                      => 'icon-wpb-banner extended-custom-icon',
					'allowed_container_element' => 'vc_row',
					'params'                    => array(
						array(
							'type'        => 'textfield',
							'param_name'  => 'custom_class',
							'heading'     => esc_html__( 'Custom CSS Class', 'oaza-core' ),
							'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'oaza-core' )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'type',
							'heading'     => esc_html__( 'Type', 'oaza-core' ),
							'value'       => array(
								esc_html__( 'Default', 'oaza-core' )    => '',
								esc_html__( 'Predefined', 'oaza-core' ) => 'predefined'
							)
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'layout',
							'heading'     => esc_html__( 'Layout', 'oaza-core' ),
							'value'       => array(
								esc_html__( 'Default', 'oaza-core' )           => '',
								esc_html__( 'Info On Image', 'oaza-core' )     => 'info-on-image',
								esc_html__( 'Info Beside Image', 'oaza-core' ) => 'info-beside-image'
							),
							'save_always' => true
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'orientation',
							'heading'     => esc_html__( 'Orientation', 'oaza-core' ),
							'value'       => array(
								esc_html__( 'Default', 'oaza-core' )            => '',
								esc_html__( 'Info On Left Side', 'oaza-core' )  => 'info-on-left-side',
								esc_html__( 'Info On Right Side', 'oaza-core' ) => 'info-on-right-side'
							),
							'save_always' => true,
							'dependency'  => array( 'element' => 'layout', 'value' => array( 'info-beside-image' ) )
						),
						array(
							'type'        => 'attach_image',
							'param_name'  => 'image',
							'heading'     => esc_html__( 'Image', 'oaza-core' ),
							'description' => esc_html__( 'Select image from media library', 'oaza-core' )
						),
						array(
							'type'       => 'colorpicker',
							'param_name' => 'overlay_color',
							'heading'    => esc_html__( 'Image Overlay Color', 'oaza-core' )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'info_position',
							'heading'     => esc_html__( 'Info Position', 'oaza-core' ),
							'value'       => array(
								esc_html__( 'Default', 'oaza-core' )         => '',
								esc_html__( 'Centered', 'oaza-core' )        => 'centered',
								esc_html__( 'Centered in Box', 'oaza-core' ) => 'centered-in-box'
							),
							'save_always' => true
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'info_box_shadow',
							'heading'     => esc_html__( 'Info Box Shadow', 'oaza-core' ),
							'value'       => array(
								esc_html__( 'Default', 'oaza-core' ) => '',
								esc_html__( 'Yes', 'oaza-core' )     => 'yes',
								esc_html__( 'No', 'oaza-core' )      => 'no'
							),
							'save_always' => true,
							'dependency'  => array( 'element' => 'info_position', 'value' => array( 'centered-in-box' ) )
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'info_content_width',
							'heading'     => esc_html__( 'Info Content width (% or px)', 'oaza-core' ),
							'dependency'  => array( 'element' => 'layout', 'value' => array( 'info-beside-image' ) )
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'info_content_padding',
							'heading'     => esc_html__( 'Info Content Padding', 'oaza-core' ),
							'description' => esc_html__( 'Please insert padding in format top right bottom left', 'oaza-core' )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'subtitle',
							'heading'    => esc_html__( 'Subtitle', 'oaza-core' )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'subtitle_tag',
							'heading'     => esc_html__( 'Subtitle Tag', 'oaza-core' ),
							'value'       => array_flip( oaza_mikado_get_title_tag( true, array( 'p' => 'p' ) ) ),
							'save_always' => true,
							'dependency'  => array( 'element' => 'subtitle', 'not_empty' => true )
						),
						array(
							'type'       => 'colorpicker',
							'param_name' => 'subtitle_color',
							'heading'    => esc_html__( 'Subtitle Color', 'oaza-core' ),
							'dependency' => array( 'element' => 'subtitle', 'not_empty' => true )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'price',
							'heading'    => esc_html__( 'Price', 'oaza-core' )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'price_font_size',
							'heading'    => esc_html__( 'Price Font Size (px)', 'oaza-core' ),
							'dependency' => array( 'element' => 'price', 'not_empty' => true )
						),
						array(
							'type'       => 'colorpicker',
							'param_name' => 'price_color',
							'heading'    => esc_html__( 'Price Color', 'oaza-core' ),
							'dependency' => array( 'element' => 'price', 'not_empty' => true )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'price_top_margin',
							'heading'    => esc_html__( 'Price Top Margin (px)', 'oaza-core' ),
							'dependency' => array( 'element' => 'price', 'not_empty' => true )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'title',
							'heading'    => esc_html__( 'Title', 'oaza-core' )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'title_tag',
							'heading'     => esc_html__( 'Title Tag', 'oaza-core' ),
							'value'       => array_flip( oaza_mikado_get_title_tag( true, array( 'p' => 'p' ) ) ),
							'save_always' => true,
							'dependency'  => array( 'element' => 'title', 'not_empty' => true )
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'title_light_words',
							'heading'     => esc_html__( 'Words with Light Font Weight', 'oaza-core' ),
							'description' => esc_html__( 'Enter the positions of the words you would like to display in a "light" font weight. Separate the positions with commas (e.g. if you would like the first, third, and fourth word to have a light font weight, you would enter "1,3,4")', 'oaza-core' ),
							'dependency'  => array( 'element' => 'title', 'not_empty' => true )
						),
						array(
							'type'       => 'colorpicker',
							'param_name' => 'title_color',
							'heading'    => esc_html__( 'Title Color', 'oaza-core' ),
							'dependency' => array( 'element' => 'title', 'not_empty' => true )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'title_top_margin',
							'heading'    => esc_html__( 'Title Top Margin (px)', 'oaza-core' ),
							'dependency' => array( 'element' => 'title', 'not_empty' => true )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'link',
							'heading'    => esc_html__( 'Link', 'oaza-core' )
						),
						array(
							'type'       => 'dropdown',
							'param_name' => 'target',
							'heading'    => esc_html__( 'Target', 'oaza-core' ),
							'value'      => array_flip( oaza_mikado_get_link_target_array() ),
							'dependency' => array( 'element' => 'link', 'not_empty' => true )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'link_text',
							'heading'    => esc_html__( 'Link Text', 'oaza-core' ),
							'dependency' => array( 'element' => 'link', 'not_empty' => true )
						),
						array(
							'type'       => 'colorpicker',
							'param_name' => 'link_color',
							'heading'    => esc_html__( 'Link Text Color', 'oaza-core' ),
							'dependency' => array( 'element' => 'link', 'not_empty' => true )
						),
						array(
							'type'       => 'colorpicker',
							'param_name' => 'link_border_color',
							'heading'    => esc_html__( 'Link Text Border Color', 'oaza-core' ),
							'dependency' => array( 'element' => 'link', 'not_empty' => true )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'link_top_margin',
							'heading'    => esc_html__( 'Link Text Top Margin (px)', 'oaza-core' ),
							'dependency' => array( 'element' => 'link', 'not_empty' => true )
						)
					)
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$args   = array(
			'custom_class'         => '',
			'type'                 => '',
			'layout'               => '',
			'orientation'          => '',
			'image'                => '',
			'overlay_color'        => '',
			'info_position'        => 'centered',
			'info_box_shadow'      => '',
			'info_content_width'   => '',
			'info_content_padding' => '',
			'subtitle'             => '',
			'subtitle_tag'         => 'h3',
			'subtitle_color'       => '',
			'price'                => '',
			'price_font_size'      => '',
			'price_color'          => '',
			'price_top_margin'     => '',
			'title'                => '',
			'title_tag'            => 'h3',
			'title_light_words'    => '',
			'title_color'          => '',
			'title_top_margin'     => '',
			'link'                 => '',
			'target'               => '_self',
			'link_text'            => '',
			'link_color'           => '',
			'link_border_color'    => '',
			'link_top_margin'      => ''
		);
		$params = shortcode_atts( $args, $atts );

		$params['holder_classes']          = $this->getHolderClasses( $params, $args );
		$params['background_image_styles'] = $this->getBackgroundImageStyles( $params );
		$params['overlay_styles']          = $this->getOverlayStyles( $params );
		$params['inner_overlay_styles']    = $this->getInnerOverlayStyles( $params );
		$params['info_position']           = ! empty( $params['info_position'] ) ? $params['info_position'] : $args['info_position'];
		$params['subtitle_tag']            = ! empty( $params['subtitle_tag'] ) ? $params['subtitle_tag'] : $args['subtitle_tag'];
		$params['subtitle_styles']         = $this->getSubitleStyles( $params );
		$params['price_styles']            = $this->getPriceStyles( $params );
		$params['title']                   = $this->getModifiedTitle( $params );
		$params['title_tag']               = ! empty( $params['title_tag'] ) ? $params['title_tag'] : $args['title_tag'];
		$params['title_styles']            = $this->getTitleStyles( $params );
		$params['link_styles']             = $this->getLinkStyles( $params );
		
		$html = oaza_core_get_shortcode_module_template_part( 'templates/banner', 'banner', '', $params );
		
		return $html;
	}
	
	private function getHolderClasses( $params, $args ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		$holderClasses[] = ! empty( $params['type'] ) ? 'mkdf-' . $params['type'] . '-type' : '';
		$holderClasses[] = ! empty( $params['layout'] ) ? 'mkdf-banner-' . $params['layout'] : '';
		$holderClasses[] = ! empty( $params['orientation'] ) ? 'mkdf-banner-' . $params['orientation'] : '';
		$holderClasses[] = ! empty( $params['info_position'] ) ? 'mkdf-banner-info-' . $params['info_position'] : 'mkdf-banner-info-' . $args['info_position'];
		$holderClasses[] = $params['info_box_shadow'] === 'yes' ? 'mkdf-banner-info-box-shadow' : '';

		return implode( ' ', $holderClasses );
	}

	private function getBackgroundImageStyles( $params ) {
		$styles = array();

		if ( $params['layout'] === 'info-beside-image' && ! empty( $params['image'] ) ) {
			$image_original = wp_get_attachment_image_src( $params['image'], 'full' );

			$styles[] = 'background-image: url(' . $image_original[0] . ')';
			$styles[] = 'background-repeat: no-repeat';
			if ($params['orientation'] === 'info-on-right-side') {
				$styles[] = 'background-position: left center';
			} else {
				$styles[] = 'background-position: right center';
			}
            $styles[] = 'background-size: auto 100%';
		}

		return implode( ';', $styles );
	}

	private function getOverlayStyles( $params ) {
		$styles = array();
		
		if ( $params['info_position'] !== 'centered-in-box' && ! empty( $params['overlay_color'] ) ) {
			$styles[] = 'background-color: ' . $params['overlay_color'];
		}

		if ( $params['layout'] === 'info-beside-image' && ! empty( $params['info_content_width'] ) ) {
			if ( oaza_mikado_string_ends_with( $params['info_content_width'], '%' ) || oaza_mikado_string_ends_with( $params['info_content_width'], 'px' ) ) {
				$styles[] = 'width: ' . $params['info_content_width'];
			} else {
				$styles[] = 'width: ' . oaza_mikado_filter_px( $params['info_content_width'] ) . 'px';
			}
		}

		if ( ! empty( $params['info_content_padding'] ) ) {
			$styles[] = 'padding: ' . $params['info_content_padding'];
		}
		
		return implode( ';', $styles );
	}

	private function getInnerOverlayStyles( $params ) {
		$styles = array();

		if ( $params['info_position'] === 'centered-in-box' && ! empty( $params['overlay_color'] ) ) {
			$styles[] = 'background-color: ' . $params['overlay_color'];
		}

		return implode( ';', $styles );
	}
	
	private function getSubitleStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['subtitle_color'] ) ) {
			$styles[] = 'color: ' . $params['subtitle_color'];
		}
		
		return implode( ';', $styles );
	}
	
	private function getPriceStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['price_font_size'] ) ) {
			$styles[] = 'font-size: ' . $params['price_font_size'];
		}
		
		if ( ! empty( $params['price_color'] ) ) {
			$styles[] = 'color: ' . $params['price_color'];
		}
		
		if ( ! empty( $params['price_top_margin'] ) ) {
			$styles[] = 'margin-top: ' . oaza_mikado_filter_px( $params['price_top_margin'] ) . 'px';
		}
		
		return implode( ';', $styles );
	}
	
	private function getModifiedTitle( $params ) {
		$title             = $params['title'];
		$title_light_words = str_replace( ' ', '', $params['title_light_words'] );
		
		if ( ! empty( $title ) ) {
			$light_words = explode( ',', $title_light_words );
			$split_title = explode( ' ', $title );
			
			if ( ! empty( $title_light_words ) ) {
				foreach ( $light_words as $value ) {
					if ( ! empty( $split_title[ $value - 1 ] ) ) {
						$split_title[ $value - 1 ] = '<span class="mkdf-banner-title-light">' . $split_title[ $value - 1 ] . '</span>';
					}
				}
			}
			
			$title = implode( ' ', $split_title );
		}
		
		return $title;
	}
	
	private function getTitleStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['title_color'] ) ) {
			$styles[] = 'color: ' . $params['title_color'];
		}
		
		if ( ! empty( $params['title_top_margin'] ) ) {
			$styles[] = 'margin-top: ' . oaza_mikado_filter_px( $params['title_top_margin'] ) . 'px';
		}
		
		return implode( ';', $styles );
	}
	
	private function getLinkStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['link_color'] ) ) {
			$styles[] = 'color: ' . $params['link_color'];
		}
		
		if ( ! empty( $params['link_border_color'] ) ) {
			$styles[] = 'border-color: ' . $params['link_border_color'];
		}
		
		if ( ! empty( $params['link_top_margin'] ) ) {
			$styles[] = 'margin-top: ' . oaza_mikado_filter_px( $params['link_top_margin'] ) . 'px';
		}
		
		return implode( ';', $styles );
	}
}