<div class="mkdf-banner-holder <?php echo esc_attr($holder_classes); ?>">
	<div class="mkdf-banner-holder-inner">
		<?php if (!empty($background_image_styles)) { ?>
			<div class="mkdf-banner-bg-image" <?php echo oaza_mikado_get_inline_style($background_image_styles); ?>></div>
		<?php } ?>
		<?php if (!empty($image)) : ?>
		    <div class="mkdf-banner-image">
		        <?php echo wp_get_attachment_image($image, 'full'); ?>
		    </div>
		<?php endif ?>
	    <div class="mkdf-banner-text-holder" <?php echo oaza_mikado_get_inline_style($overlay_styles); ?>>
		    <div class="mkdf-banner-text-outer" <?php echo oaza_mikado_get_inline_style($inner_overlay_styles); ?>>
			    <div class="mkdf-banner-text-inner">
			        <?php if(!empty($subtitle)) { ?>
				    <<?php echo esc_attr($subtitle_tag); ?> class="mkdf-banner-subtitle" <?php echo oaza_mikado_get_inline_style($subtitle_styles); ?>>
				            <?php echo esc_html($subtitle); ?>
			            </<?php echo esc_attr($subtitle_tag); ?>>
			        <?php } ?>
				    <?php if(!empty($price)) { ?>
					    <h3 class="mkdf-banner-price" <?php echo oaza_mikado_get_inline_style($price_styles); ?>>
						    <?php echo esc_html($price); ?>
					    </h3>
				    <?php } ?>
			        <?php if(!empty($title)) { ?>
			            <<?php echo esc_attr($title_tag); ?> class="mkdf-banner-title" <?php echo oaza_mikado_get_inline_style($title_styles); ?>>
			                <?php echo wp_kses($title, array('span' => array('class' => true))); ?>
		                </<?php echo esc_attr($title_tag); ?>>
			        <?php } ?>
					<?php if(!empty($link) && !empty($link_text)) { ?>
			            <a itemprop="url" href="<?php echo esc_url($link); ?>" target="<?php echo esc_attr($target); ?>" class="mkdf-btn mkdf-btn-medium mkdf-btn-outline mkdf-btn-custom-hover-color mkdf-price-link" <?php echo oaza_mikado_get_inline_style($link_styles); ?>>
				            <span class="mkdf-btn-text"><?php echo esc_html($link_text); ?></span>
			            </a>
			        <?php } ?>
				</div>
			</div>
		</div>
	</div>
</div>