<?php
if ( ! function_exists( 'oaza_core_load_widget_class' ) ) {
	/**
	 * Loades widget class file.
	 */
	function oaza_core_load_widget_class() {
		include_once 'widget-class.php';
	}

	add_action( 'oaza_mikado_action_before_options_map', 'oaza_core_load_widget_class' );
}

if ( ! function_exists( 'oaza_core_load_widgets' ) ) {
	/**
	 * Loades all widgets by going through all folders that are placed directly in widgets folder
	 * and loads load.php file in each. Hooks to oaza_mikado_action_after_options_map action
	 */
	function oaza_core_load_widgets() {
		foreach ( glob( OAZA_CORE_ABS_PATH . '/widgets/*/load.php' ) as $widget_load ) {
			include_once $widget_load;
		}

		include_once 'widget-loader.php';
	}

	add_action( 'oaza_mikado_action_before_options_map', 'oaza_core_load_widgets' );
}