<?php

namespace OazaInstagram\Shortcodes\InstagramList;

use OazaInstagram\Lib;


class InstagramList implements Lib\ShortcodeInterface
{
    private $base;

    public function __construct()
    {
        $this->base = 'mkdf_instagram_list';

        add_action('vc_before_init', array($this, 'vcMap'));
    }

    public function getBase()
    {
        return $this->base;
    }

    public function vcMap()
    {
        if (function_exists('vc_map')) {
            vc_map(
                array(
                    'name' => esc_html__('Mikado Instagram List', 'oaza-instagram-feed'),
                    'base' => $this->base,
                    'category' => esc_html__('by OAZA', 'oaza-instagram-feed'),
                    'icon' => 'icon-wpb-instagram-list extended-custom-icon',
                    'allowed_container_element' => 'vc_row',
                    'params' => array(
                        array(
                            'param_name' => 'type',
                            'type' => 'dropdown',
                            'heading' => esc_html__('Type', 'oaza-instagram-feed'),
                            'value' => array(
                                esc_html__( 'Gallery', 'oaza-instagram-feed') => 'gallery',
                                esc_html__( 'Carousel', 'oaza-instagram-feed') => 'carousel'
                            )
                        ),
                    	array(
                            'type' => 'dropdown',
                            'param_name' => 'number_of_columns',
                            'heading' => esc_html__('Number of Columns', 'oaza-instagram-feed'),
                            'value' => array(
	                            esc_html__( 'One', 'oaza-instagram-feed' )   => '1',
	                            esc_html__( 'Two', 'oaza-instagram-feed' )   => '2',
	                            esc_html__( 'Three', 'oaza-instagram-feed' ) => '3',
	                            esc_html__( 'Four', 'oaza-instagram-feed' )  => '4',
	                            esc_html__( 'Five', 'oaza-instagram-feed' )  => '5',
	                            esc_html__( 'Six', 'oaza-instagram-feed' )   => '6',
	                            esc_html__( 'Nine', 'oaza-instagram-feed' )  => '9'
                            ),
                            'save_always' => true
                        ),
                        array(
                            'param_name' => 'space_between_columns',
                            'type' => 'dropdown',
                            'heading' => esc_html__('Space Between Items', 'oaza-instagram-feed'),
                            'value' => array_flip(oaza_mikado_get_space_between_items_array( false, array( 'large', 'huge' ) )),
                            'save_always' => true
                        ),
                        array(
                            'type' => 'textfield',
                            'param_name' => 'number_of_photos',
                            'heading' => esc_html__('Number of Photos', 'oaza-instagram-feed')
                        ),
                        array(
                            'type' => 'textfield',
                            'param_name' => 'transient_time',
                            'heading' => esc_html__('Images Cache Time', 'oaza-instagram-feed')
                        ),

                        array(
                            'param_name' => 'show_instagram_icon',
                            'type' => 'dropdown',
                            'heading' => esc_html__('Show Instagram Icon', 'oaza-instagram-feed'),
                            'value' => array_flip(oaza_mikado_get_yes_no_select_array(false)),
                        ),

                        array(
                            'param_name' => 'image_size',
                            'type' => 'dropdown',
                            'heading' => esc_html__('Image Size', 'oaza-instagram-feed'),
                            'value' => array(
                                esc_html__( 'Small', 'oaza-instagram-feed') => 'thumbnail',
                                esc_html__( 'Medium', 'oaza-instagram-feed') => 'low_resolution',
                                esc_html__( 'Large', 'oaza-instagram-feed') => 'standard_resolution'
                            )
                        ),
                        array(
                            'type' => 'dropdown',
                            'param_name' => 'slider_loop',
                            'heading' => esc_html__('Enable Slider Loop', 'oaza-instagram-feed'),
                            'value' => array_flip(oaza_mikado_get_yes_no_select_array(false, true)),
                            'save_always' => true,
                            'group' => esc_html__('Slider Settings', 'oaza-instagram-feed')
                        ),
                        array(
                            'type' => 'dropdown',
                            'param_name' => 'slider_autoplay',
                            'heading' => esc_html__('Enable Slider Autoplay', 'oaza-instagram-feed'),
                            'value' => array_flip(oaza_mikado_get_yes_no_select_array(false, true)),
                            'save_always' => true,
                            'group' => esc_html__('Slider Settings', 'oaza-instagram-feed')
                        ),
                        array(
                            'type' => 'textfield',
                            'param_name' => 'slider_speed',
                            'heading' => esc_html__('Slide Duration', 'oaza-instagram-feed'),
                            'description' => esc_html__('Default value is 5000 (ms)', 'oaza-instagram-feed'),
                            'group' => esc_html__('Slider Settings', 'oaza-instagram-feed')
                        ),
                        array(
                            'type' => 'textfield',
                            'param_name' => 'slider_speed_animation',
                            'heading' => esc_html__('Slide Animation Duration', 'oaza-instagram-feed'),
                            'description' => esc_html__('Speed of slide animation in milliseconds. Default value is 600.', 'oaza-instagram-feed'),
                            'group' => esc_html__('Slider Settings', 'oaza-instagram-feed')
                        ),
                        array(
                            'type' => 'dropdown',
                            'param_name' => 'slider_navigation',
                            'heading' => esc_html__('Enable Slider Navigation Arrows', 'oaza-instagram-feed'),
                            'value' => array_flip(oaza_mikado_get_yes_no_select_array(false, true)),
                            'save_always' => true,
                            'group' => esc_html__('Slider Settings', 'oaza-instagram-feed')
                        ),
                        array(
                            'type' => 'dropdown',
                            'param_name' => 'slider_pagination',
                            'heading' => esc_html__('Enable Slider Pagination', 'oaza-instagram-feed'),
                            'value' => array_flip(oaza_mikado_get_yes_no_select_array(false, false)),
                            'save_always' => true,
                            'group' => esc_html__('Slider Settings', 'oaza-instagram-feed')
                        )
                    )
                )
            );
        }
    }

    public function render($atts, $content = null)
    {
        $args = array(
            'number_of_columns' => '3',
            'space_between_columns' => 'normal',
            'number_of_photos' => '',
            'transient_time' => '',
            'show_instagram_icon' => 'no',
            'type' => 'gallery',
            'image_size' => 'thumbnail',
            'slider_loop' => 'yes',
            'slider_autoplay' => 'yes',
            'slider_speed' => '5000',
            'slider_speed_animation' => '600',
            'slider_navigation' => 'yes',
            'slider_pagination' => 'no'
        );
        $params = shortcode_atts($args, $atts);
        extract($params);

        $params['holder_classes'] = $this->getHolderClasses($params);

        $instagram_api = new \OazaInstagramApi();
        $params['instagram_api'] = $instagram_api;

        $images_array = $instagram_api->getImages($params['number_of_photos'], array(
            'use_transients' => true,
            'transient_name' => rand(0, 1000),
            'transient_time' => $params['transient_time']
        ));

        $params['images_array'] = $images_array;
        $params['data_attr'] = $this->getSliderData($params);

        //Get HTML from template based on type of team
        $html = oaza_instagram_get_shortcode_module_template_part('templates/holder', 'instagram-list', '', $params);

        return $html;
    }

    public function getHolderClasses($params)
    {
        $holderClasses = array();
	
	    $holderClasses[] = !empty($params['number_of_columns']) ? 'mkdf-col-' . $params['number_of_columns'] : 'mkdf-col-3';
        $holderClasses[] = !empty($params['space_between_columns']) ? 'mkdf-' . $params['space_between_columns'] . '-space' : 'mkdf-normal-space';

        if ($params['type'] === 'carousel') {
            $holderClasses[] = 'mkdf-instagram-carousel mkdf-owl-slider';

        } else if ($params['type'] == 'gallery') {
            $holderClasses[] = 'mkdf-instagram-gallery';
        }

        return implode(' ', $holderClasses);
    }

    private function getSliderData($params) {
        $slider_data = array();

        $slider_data['data-number-of-items'] = $params['number_of_columns'];
        $slider_data['data-enable-loop'] = !empty($params['slider_loop']) ? $params['slider_loop'] : '';
        $slider_data['data-enable-autoplay'] = !empty($params['slider_autoplay']) ? $params['slider_autoplay'] : '';
        $slider_data['data-slider-speed'] = !empty($params['slider_speed']) ? $params['slider_speed'] : '5000';
        $slider_data['data-slider-speed-animation'] = !empty($params['slider_speed_animation']) ? $params['slider_speed_animation'] : '600';
        $slider_data['data-enable-navigation'] = !empty($params['slider_navigation']) ? $params['slider_navigation'] : '';
        $slider_data['data-enable-pagination'] = !empty($params['slider_pagination']) ? $params['slider_pagination'] : '';

        $slider_margin = 0;
		if ( $params['space_between_columns'] === 'medium' ) {
			$slider_margin = 40;
		} else if ( $params['space_between_columns'] === 'normal' ) {
			$slider_margin = 30;
		} else if ( $params['space_between_columns'] === 'small' ) {
			$slider_margin = 20;
		} else if ( $params['space_between_columns'] === 'tiny' ) {
			$slider_margin = 10;
		} else if ( $params['space_between_columns'] === 'no' ) {
			$slider_margin = 0;
		}

		$slider_data['data-slider-margin']     = esc_attr( $slider_margin );

        return $slider_data;
    }
}