<?php

if ( oaza_business_theme_installed() ) {
	if ( ! function_exists( 'oaza_business_options_map' ) ) {
		/**
		 * Adds admin page for OpenTable integration
		 */
		function oaza_business_options_map() {
			oaza_mikado_add_admin_page(
				array(
					'title' => esc_html__( 'Business Working Hours', 'oaza-business' ),
					'slug'  => '_business',
					'icon'  => 'fa fa-briefcase'
				)
			);
			
			// Working Hours panel
			$panel_working_hours = oaza_mikado_add_admin_panel(
				array(
					'page'  => '_business',
					'name'  => 'panel_working_hours',
					'title' => esc_html__( 'Working Hours', 'oaza-business' )
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'        => 'working_hours_layout',
					'type'        => 'select',
					'label'       => esc_html__( 'Working Hours Layout', 'oaza-business' ),
					'description' => esc_html__( 'Layout will be used in Working Hours shortcode', 'oaza-business' ),
					'options'     => array(
						''                            => esc_html__( '- Choose Working Hours Layout', 'oaza-business' ),
						'all-days'                    => esc_html__( 'All Days', 'oaza-business' ),
						'workdays-weekend'            => esc_html__( 'Workdays + Weekend', 'oaza-business' ),
						'workdays-sat-sun'            => esc_html__( 'Workdays + Sat + Sun', 'oaza-business' ),
						'same'                        => esc_html__( 'Same Throught the Week', 'oaza-business' ),
						'mon-tue-wed-thu-fri-weekend' => esc_html__( 'Mon + Tue + Wed + Thu + Fri + Weekend', 'oaza-business' ),
					),
					'parent'      => $panel_working_hours
				)
			);

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
			
			$weekend_container = oaza_mikado_add_admin_container_no_style(
				array(
					'name'            => 'same_container',
					'hidden_property' => '',
					'hidden_value'    => '',
					'parent'          => $panel_working_hours,
					'dependency'      => array(
						'hide' => array(
							'working_hours_layout' => array(
								'',
								'all-days',
								'workdays-weekend',
								'workdays-sat-sun',
								'mon-tue-wed-thu-fri-weekend'
							)
						)
					)
				)
			);
			
			$same_group = oaza_mikado_add_admin_group(
				array(
					'name'        => 'same_group',
					'title'       => esc_html__( 'All Days', 'oaza-business' ),
					'parent'      => $weekend_container,
					'description' => esc_html__( 'Same throught the week', 'oaza-business' )
				)
			);
			
			$same_row = oaza_mikado_add_admin_row(
				array(
					'name'   => 'same_row',
					'parent' => $same_group
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'wh_same_from',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'From', 'oaza-business' ),
					'parent' => $same_row
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'wh_same_to',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'To', 'oaza-business' ),
					'parent' => $same_row
				)
			);

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
			
			$work_days_container = oaza_mikado_add_admin_container_no_style(
				array(
					'name'            => 'work_days_container',
					'hidden_property' => '',
					'hidden_value'    => '',
					'parent'          => $panel_working_hours,
					'dependency'      => array(
						'hide' => array(
							'working_hours_layout' => array(
								'',
								'all-days',
								'same',
								'mon-tue-wed-thu-fri-weekend'
							)
						)
					)
				)
			);
			
			$work_days_group = oaza_mikado_add_admin_group(
				array(
					'name'        => 'work_days_group',
					'title'       => esc_html__( 'Work Days', 'oaza-business' ),
					'parent'      => $work_days_container,
					'description' => esc_html__( 'Working hours for workdays', 'oaza-business' )
				)
			);
			
			$work_days_row = oaza_mikado_add_admin_row(
				array(
					'name'   => 'work_days_row',
					'parent' => $work_days_group
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'wh_work_days_from',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'From', 'oaza-business' ),
					'parent' => $work_days_row
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'wh_work_days_to',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'To', 'oaza-business' ),
					'parent' => $work_days_row
				)
			);

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
			
			$single_work_days_container = oaza_mikado_add_admin_container_no_style(
				array(
					'name'            => 'single_work_days_container',
					'hidden_property' => '',
					'hidden_value'    => '',
					'parent'          => $panel_working_hours,
					'dependency'      => array(
						'hide' => array(
							'working_hours_layout' => array(
								'',
								'workdays-weekend',
								'workdays-sat-sun',
								'same'
							)
						)
					)
				)
			);
			
			$monday_group = oaza_mikado_add_admin_group(
				array(
					'name'        => 'monday_group',
					'title'       => esc_html__( 'Monday', 'oaza-business' ),
					'parent'      => $single_work_days_container,
					'description' => esc_html__( 'Working hours for Monday', 'oaza-business' )
				)
			);
			
			$monday_row = oaza_mikado_add_admin_row(
				array(
					'name'   => 'monday_row',
					'parent' => $monday_group
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'wh_monday_from',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'From', 'oaza-business' ),
					'parent' => $monday_row
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'wh_monday_to',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'To', 'oaza-business' ),
					'parent' => $monday_row
				)
			);
			
			$tuesday_group = oaza_mikado_add_admin_group(
				array(
					'name'        => 'tuesday_group',
					'title'       => esc_html__( 'Tuesday', 'oaza-business' ),
					'parent'      => $single_work_days_container,
					'description' => esc_html__( 'Working hours for Tuesday', 'oaza-business' )
				)
			);
			
			$tuesday_row = oaza_mikado_add_admin_row(
				array(
					'name'   => 'tuesday_row',
					'parent' => $tuesday_group
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'wh_tuesday_from',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'From', 'oaza-business' ),
					'parent' => $tuesday_row
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'wh_tuesday_to',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'To', 'oaza-business' ),
					'parent' => $tuesday_row
				)
			);
			
			$wednesday_group = oaza_mikado_add_admin_group(
				array(
					'name'        => 'wednesday_group',
					'title'       => esc_html__( 'Wednesday', 'oaza-business' ),
					'parent'      => $single_work_days_container,
					'description' => esc_html__( 'Working hours for Wednesday', 'oaza-business' )
				)
			);
			
			$wednesday_row = oaza_mikado_add_admin_row(
				array(
					'name'   => 'wednesday_row',
					'parent' => $wednesday_group
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'wh_wednesday_from',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'From', 'oaza-business' ),
					'parent' => $wednesday_row
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'wh_wednesday_to',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'To', 'oaza-business' ),
					'parent' => $wednesday_row
				)
			);
			
			$thursday_group = oaza_mikado_add_admin_group(
				array(
					'name'        => 'thursday_group',
					'title'       => esc_html__( 'Thursday', 'oaza-business' ),
					'parent'      => $single_work_days_container,
					'description' => 'Working hours for Thursday'
				)
			);
			
			$thursday_row = oaza_mikado_add_admin_row(
				array(
					'name'   => 'thursday_row',
					'parent' => $thursday_group
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'wh_thursday_from',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'From', 'oaza-business' ),
					'parent' => $thursday_row
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'wh_thursday_to',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'To', 'oaza-business' ),
					'parent' => $thursday_row
				)
			);
			
			$friday_group = oaza_mikado_add_admin_group(
				array(
					'name'        => 'friday_group',
					'title'       => esc_html__( 'Friday', 'oaza-business' ),
					'parent'      => $single_work_days_container,
					'description' => esc_html__( 'Working hours for Friday', 'oaza-business' )
				)
			);
			
			$friday_row = oaza_mikado_add_admin_row(
				array(
					'name'   => 'friday_row',
					'parent' => $friday_group
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'wh_friday_from',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'From', 'oaza-business' ),
					'parent' => $friday_row
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'wh_friday_to',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'To', 'oaza-business' ),
					'parent' => $friday_row
				)
			);

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
			
			$weekend_container = oaza_mikado_add_admin_container_no_style(
				array(
					'name'            => 'weekend_container',
					'hidden_property' => '',
					'hidden_value'    => '',
					'parent'          => $panel_working_hours,
					'dependency'      => array(
						'hide' => array(
							'working_hours_layout' => array(
								'',
								'all-days',
								'workdays-sat-sun',
								'same'
							)
						)
					)
				)
			);
			
			$weekend_group = oaza_mikado_add_admin_group(
				array(
					'name'        => 'weekend_group',
					'title'       => esc_html__( 'Weekend', 'oaza-business' ),
					'parent'      => $weekend_container,
					'description' => esc_html__( 'Working hours for weekend', 'oaza-business' )
				)
			);
			
			$weekend_row = oaza_mikado_add_admin_row(
				array(
					'name'   => 'weekend_row',
					'parent' => $weekend_group
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'wh_weekend_from',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'From', 'oaza-business' ),
					'parent' => $weekend_row
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'wh_weekend_to',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'To', 'oaza-business' ),
					'parent' => $weekend_row
				)
			);

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
			
			$single_weekend_container = oaza_mikado_add_admin_container_no_style(
				array(
					'name'            => 'single_weekend_container',
					'hidden_property' => '',
					'hidden_value'    => '',
					'parent'          => $panel_working_hours,
					'dependency'      => array(
						'hide' => array(
							'working_hours_layout' => array(
								'',
								'workdays-weekend',
								'same',
								'mon-tue-wed-thu-fri-weekend',
							)
						)
					)
				)
			);
			
			$saturday_group = oaza_mikado_add_admin_group(
				array(
					'name'        => 'saturday_group',
					'title'       => esc_html__( 'Saturday', 'oaza-business' ),
					'parent'      => $single_weekend_container,
					'description' => esc_html__( 'Working hours for Saturday', 'oaza-business' )
				)
			);
			
			$saturday_row = oaza_mikado_add_admin_row(
				array(
					'name'   => 'saturday_row',
					'parent' => $saturday_group
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'wh_saturday_from',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'From', 'oaza-business' ),
					'parent' => $saturday_row
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'wh_saturday_to',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'To', 'oaza-business' ),
					'parent' => $saturday_row
				)
			);
			
			$sunday_group = oaza_mikado_add_admin_group(
				array(
					'name'        => 'sunday_group',
					'title'       => esc_html__( 'Sunday', 'oaza-business' ),
					'parent'      => $single_weekend_container,
					'description' => esc_html__( 'Working hours for Sunday', 'oaza-business' )
				)
			);
			
			$sunday_row = oaza_mikado_add_admin_row(
				array(
					'name'   => 'sunday_row',
					'parent' => $sunday_group
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'wh_sunday_from',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'From', 'oaza-business' ),
					'parent' => $sunday_row
				)
			);
			
			oaza_mikado_add_admin_field(
				array(
					'name'   => 'wh_sunday_to',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'To', 'oaza-business' ),
					'parent' => $sunday_row
				)
			);
		}

        add_action('oaza_mikado_action_options_map', 'oaza_business_options_map', 71); // one after elements
    }
}