<?php
/*
Plugin Name: Oaza Business
Description: Plugin that adds features to our theme
Author: Mikado Themes
Version: 1.0.1
*/

include_once 'load.php';

if ( ! function_exists( 'oaza_business_load_assets' ) ) {
	function oaza_business_load_assets() {
		wp_enqueue_style( 'oaza-mikado-business-style', plugins_url( '/assets/css/business.min.css', __FILE__ ), array(), '' );

		if ( function_exists( 'oaza_mikado_is_responsive_on' ) && oaza_mikado_is_responsive_on() ) {
			wp_enqueue_style( 'oaza-mikado-business-responsive-style', plugins_url( '/assets/css/business-responsive.min.css', __FILE__ ), array(), '' );
		}

		wp_enqueue_script( 'jquery-ui-datepicker' );
		wp_enqueue_script( 'oaza-mikado-business-script', plugins_url( '/assets/js/business.min.js', __FILE__ ), array( 'jquery' ), '', true );
	}

	add_action( 'wp_enqueue_scripts', 'oaza_business_load_assets', 11 );
}

if ( ! function_exists( 'oaza_business_style_dynamics_deps' ) ) {
	function oaza_business_style_dynamics_deps( $deps ) {
		$style_dynamic_deps_array   = array();
		$style_dynamic_deps_array[] = 'oaza-mikado-business-style';

		if ( function_exists( 'oaza_mikado_is_responsive_on' ) && oaza_mikado_is_responsive_on() ) {
			$style_dynamic_deps_array[] = 'oaza-mikado-business-responsive-style';
		}

		return array_merge( $deps, $style_dynamic_deps_array );
	}

	add_filter( 'oaza_mikado_filter_style_dynamic_deps', 'oaza_business_style_dynamics_deps' );
}