<?php
namespace OazaBusiness\Shortcodes\BookedAppointments;

use OazaBusiness\Lib\ShortcodeInterface;

class BookedAppointments implements ShortcodeInterface
{
    private $base;

    public function __construct() {
        $this->base = 'mkdf_booked_appointments';

        add_action('vc_before_init', array($this, 'vcMap'));
    }

    public function getBase() {
        return $this->base;
    }

    public function vcMap() {
        vc_map(array(
	        'name'                    => esc_html__( 'Booked Appointments', 'oaza-business' ),
	        'base'                    => $this->base,
	        'category'                => esc_html__( 'by OAZA BUSINESS', 'oaza-business' ),
	        'icon'                    => 'icon-wpb-booked-appointments extended-custom-business-icon',
	        'show_settings_on_create' => false
        ));
    }

    public function render( $atts, $content = null ) {
		$html = '<div class="mkdf-booked-appointments">';
			$html .= do_shortcode( '[booked-appointments]' );
		$html .= '</div>';

		return $html;
	}
}