<?php

if ( ! function_exists( 'oaza_core_map_portfolio_meta' ) ) {
	function oaza_core_map_portfolio_meta() {
		global $oaza_mikado_global_Framework;
		
		$oaza_pages = array();
		$pages      = get_pages();
		foreach ( $pages as $page ) {
			$oaza_pages[ $page->ID ] = $page->post_title;
		}
		
		//Portfolio Images
		
		$oaza_portfolio_images = new OazaMikadoClassMetaBox( 'portfolio-item', esc_html__( 'Portfolio Images (multiple upload)', 'oaza-core' ), '', '', 'portfolio_images' );
		$oaza_mikado_global_Framework->mkdMetaBoxes->addMetaBox( 'portfolio_images', $oaza_portfolio_images );
		
		$oaza_portfolio_image_gallery = new OazaMikadoClassMultipleImages( 'mkdf-portfolio-image-gallery', esc_html__( 'Portfolio Images', 'oaza-core' ), esc_html__( 'Choose your portfolio images', 'oaza-core' ) );
		$oaza_portfolio_images->addChild( 'mkdf-portfolio-image-gallery', $oaza_portfolio_image_gallery );
		
		//Portfolio Single Upload Images/Videos 
		
		$oaza_portfolio_images_videos = oaza_mikado_create_meta_box(
			array(
				'scope' => array( 'portfolio-item' ),
				'title' => esc_html__( 'Portfolio Images/Videos (single upload)', 'oaza-core' ),
				'name'  => 'mkdf_portfolio_images_videos'
			)
		);
		oaza_mikado_add_repeater_field(
			array(
				'name'        => 'mkdf_portfolio_single_upload',
				'parent'      => $oaza_portfolio_images_videos,
				'button_text' => esc_html__( 'Add Image/Video', 'oaza-core' ),
				'fields'      => array(
					array(
						'type'        => 'select',
						'name'        => 'file_type',
						'label'       => esc_html__( 'File Type', 'oaza-core' ),
						'options' => array(
							'image' => esc_html__('Image','oaza-core'),
							'video' => esc_html__('Video','oaza-core'),
						)
					),
					array(
						'type'        => 'image',
						'name'        => 'single_image',
						'label'       => esc_html__( 'Image', 'oaza-core' ),
						'dependency' => array(
							'show' => array(
								'file_type'  => 'image'
							)
						)
					),
					array(
						'type'        => 'select',
						'name'        => 'video_type',
						'label'       => esc_html__( 'Video Type', 'oaza-core' ),
						'options'	  => array(
							'youtube' => esc_html__('YouTube', 'oaza-core'),
							'vimeo' => esc_html__('Vimeo', 'oaza-core'),
							'self' => esc_html__('Self Hosted', 'oaza-core'),
						),
						'dependency' => array(
							'show' => array(
								'file_type'  => 'video'
							)
						)
					),
					array(
						'type'        => 'text',
						'name'        => 'video_id',
						'label'       => esc_html__( 'Video ID', 'oaza-core' ),
						'dependency' => array(
							'show' => array(
								'file_type' => 'video',
								'video_type'  => array('youtube','vimeo')
							)
						)
					),
					array(
						'type'        => 'text',
						'name'        => 'video_mp4',
						'label'       => esc_html__( 'Video mp4', 'oaza-core' ),
						'dependency' => array(
							'show' => array(
								'file_type' => 'video',
								'video_type'  => 'self'
							)
						)
					),
					array(
						'type'        => 'image',
						'name'        => 'video_cover_image',
						'label'       => esc_html__( 'Video Cover Image', 'oaza-core' ),
						'dependency' => array(
							'show' => array(
								'file_type' => 'video',
								'video_type'  => 'self'
							)
						)
					)
				)
			)
		);
		
		//Portfolio Additional Sidebar Items
		
		$oaza_additional_sidebar_items = oaza_mikado_create_meta_box(
			array(
				'scope' => array( 'portfolio-item' ),
				'title' => esc_html__( 'Additional Portfolio Sidebar Items', 'oaza-core' ),
				'name'  => 'portfolio_properties'
			)
		);

		oaza_mikado_add_repeater_field(
			array(
				'name'        => 'mkdf_portfolio_properties',
				'parent'      => $oaza_additional_sidebar_items,
				'button_text' => esc_html__( 'Add New Item', 'oaza-core' ),
				'fields'      => array(
					array(
						'type'        => 'text',
						'name'        => 'item_title',
						'label'       => esc_html__( 'Item Title', 'oaza-core' ),
					),
					array(
						'type'        => 'text',
						'name'        => 'item_text',
						'label'       => esc_html__( 'Item Text', 'oaza-core' )
					),
					array(
						'type'        => 'text',
						'name'        => 'item_url',
						'label'       => esc_html__( 'Enter Full URL for Item Text Link', 'oaza-core' )
					)
				)
			)
		);
	}
	
	add_action( 'oaza_mikado_action_meta_boxes_map', 'oaza_core_map_portfolio_meta', 40 );
}