<?php

namespace OazaCore\CPT\Shortcodes\CallToAction;

use OazaCore\Lib;

class CallToAction implements Lib\ShortcodeInterface {
	private $base;
	
	public function __construct() {
		$this->base = 'mkdf_call_to_action';
		
		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map(
				array(
					'name'                      => esc_html__( 'Call To Action', 'oaza-core' ),
					'base'                      => $this->getBase(),
					'category'                  => esc_html__( 'by OAZA', 'oaza-core' ),
					'icon'                      => 'icon-wpb-call-to-action extended-custom-icon',
					'allowed_container_element' => 'vc_row',
					'params'                    => array_merge(
						array(
							array(
								'type'        => 'textfield',
								'param_name'  => 'custom_class',
								'heading'     => esc_html__( 'Custom CSS Class', 'oaza-core' ),
								'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'oaza-core' )
							),
							array(
								'type'       => 'dropdown',
								'param_name' => 'content_in_grid',
								'heading'    => esc_html__( 'Set Content In Grid', 'oaza-core' ),
								'value'      => array_flip( oaza_mikado_get_yes_no_select_array( false ) )
							),
							array(
								'type'       => 'dropdown',
								'param_name' => 'content_elements_proportion',
								'heading'    => esc_html__( 'Content Elements Proportion', 'oaza-core' ),
								'value'      => array(
									esc_html__( '80/20', 'oaza-core' ) => '80',
									esc_html__( '75/25', 'oaza-core' ) => '75',
									esc_html__( '66/33', 'oaza-core' ) => '66',
									esc_html__( '50/50', 'oaza-core' ) => '50'
								)
							),
							array(
								'type'       => 'textfield',
								'param_name' => 'link',
								'heading'    => esc_html__( 'Link', 'oaza-core' )
							),
							array(
								'type'        => 'dropdown',
								'param_name'  => 'target',
								'heading'     => esc_html__( 'Link Target', 'oaza-core' ),
								'value'       => array_flip( oaza_mikado_get_link_target_array() ),
								'save_always' => true
							)
						),
						oaza_mikado_icon_collections()->getVCParamsArray( array(), '', true ),
						array(
							array(
								'type'       => 'textarea_html',
								'param_name' => 'content',
								'heading'    => esc_html__( 'Content', 'oaza-core' ),
								'value'      => esc_html__( 'I am test text for Call to Action shortcode content', 'oaza-core' )
							)
						)
					),
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$args   = array(
			'custom_class'                => '',
			'content_in_grid'             => 'no',
			'content_elements_proportion' => '75',
			'link'                        => '',
			'target'                      => '_self'
		);
		$args   = array_merge( $args, oaza_mikado_icon_collections()->getShortcodeParams() );
		$params = shortcode_atts( $args, $atts );
		
		$iconPackName   = oaza_mikado_icon_collections()->getIconCollectionParamNameByKey( $params['icon_pack'] );
		$params['icon'] = $iconPackName ? $params[ $iconPackName ] : '';
		
		$params['content'] = preg_replace( '#^<\/p>|<p>$#', '', $content );

		$params['holder_classes']  = $this->getHolderClasses( $params );
		$params['content_in_grid'] = ! empty( $params['content_in_grid'] ) ? $params['content_in_grid'] : $args['content_in_grid'];
		$params['link']            = ! empty( $params['link'] ) ? $params['link'] : '#';
		$params['target']          = ! empty( $params['target'] ) ? $params['target'] : $args['target'];

		$html = oaza_core_get_shortcode_module_template_part( 'templates/call-to-action', 'call-to-action', '', $params );
		
		return $html;
	}
	
	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		$holderClasses[] = $params['content_in_grid'] === 'yes' ? 'mkdf-content-in-grid' : '';
		
		$content_elements_proportion = $params['content_elements_proportion'];
		
			switch ( $content_elements_proportion ):
				case '80':
					$holderClasses[] = 'mkdf-four-fifths-columns';
					break;
				case '75':
					$holderClasses[] = 'mkdf-three-quarters-columns';
					break;
				case '66':
					$holderClasses[] = 'mkdf-two-thirds-columns';
					break;
				case '50':
					$holderClasses[] = 'mkdf-two-halves-columns';
					break;
				default:
					$holderClasses[] = 'mkdf-three-quarters-columns';
					break;
			endswitch;
		
		return implode( ' ', $holderClasses );
	}
}