<?php

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	class WPBakeryShortCode_Mkdf_Layout_Holder extends WPBakeryShortCodesContainer {}
}

if ( ! function_exists( 'oaza_core_add_layout_holder_shortcodes' ) ) {
	function oaza_core_add_layout_holder_shortcodes( $shortcodes_class_name ) {
		$shortcodes = array(
			'OazaCore\CPT\Shortcodes\LayoutHolder\LayoutHolder'
		);
		
		$shortcodes_class_name = array_merge( $shortcodes_class_name, $shortcodes );
		
		return $shortcodes_class_name;
	}
	
	add_filter( 'oaza_core_filter_add_vc_shortcode', 'oaza_core_add_layout_holder_shortcodes' );
}

if ( ! function_exists( 'oaza_core_set_layout_holder_custom_style_for_vc_shortcodes' ) ) {
	/**
	 * Function that set custom css style for layout holder shortcode
	 */
	function oaza_core_set_layout_holder_custom_style_for_vc_shortcodes( $style ) {
		$current_style = '.vc_shortcodes_container.wpb_mkdf_layout_holder { 
			background-color: #f4f4f4; 
		}';
		
		$style .= $current_style;
		
		return $style;
	}
	
	add_filter( 'oaza_core_filter_add_vc_shortcodes_custom_style', 'oaza_core_set_layout_holder_custom_style_for_vc_shortcodes' );
}

if ( ! function_exists( 'oaza_core_set_layout_holder_icon_class_name_for_vc_shortcodes' ) ) {
	/**
	 * Function that set custom icon class name for layout holder shortcode to set our icon for Visual Composer shortcodes panel
	 */
	function oaza_core_set_layout_holder_icon_class_name_for_vc_shortcodes( $shortcodes_icon_class_array ) {
		$shortcodes_icon_class_array[] = '.icon-wpb-layout-holder';
		
		return $shortcodes_icon_class_array;
	}
	
	add_filter( 'oaza_core_filter_add_vc_shortcodes_custom_icon_class', 'oaza_core_set_layout_holder_icon_class_name_for_vc_shortcodes' );
}