<?php

namespace OazaCore\CPT\Shortcodes\VideoButton;

use OazaCore\Lib;

class VideoButton implements Lib\ShortcodeInterface {
	private $base;
	
	public function __construct() {
		$this->base = 'mkdf_video_button';
		
		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map(
				array(
					'name'                      => esc_html__( 'Video Button', 'oaza-core' ),
					'base'                      => $this->getBase(),
					'category'                  => esc_html__( 'by OAZA', 'oaza-core' ),
					'icon'                      => 'icon-wpb-video-button extended-custom-icon',
					'allowed_container_element' => 'vc_row',
					'params'                    => array(
						array(
							'type'        => 'textfield',
							'param_name'  => 'custom_class',
							'heading'     => esc_html__( 'Custom CSS Class', 'oaza-core' ),
							'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'oaza-core' )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'video_link',
							'heading'    => esc_html__( 'Video Link', 'oaza-core' )
						),
						array(
							'type'        => 'attach_image',
							'param_name'  => 'video_image',
							'heading'     => esc_html__( 'Video Image', 'oaza-core' ),
							'description' => esc_html__( 'Select image from media library', 'oaza-core' )
						),
						array(
							'type'       => 'colorpicker',
							'param_name' => 'play_button_color',
							'heading'    => esc_html__( 'Play Button Color', 'oaza-core' )
						),
						array(
							'type'       => 'colorpicker',
							'param_name' => 'play_button_bg_color',
							'heading'    => esc_html__( 'Play Button Background Color', 'oaza-core' )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'play_button_size',
							'heading'    => esc_html__( 'Play Button Size (px)', 'oaza-core' )
						),

						array(
							'type'       => 'textfield',
							'param_name' => 'play_button_bg_size',
							'heading'    => esc_html__( 'Play Button Background Size (px)', 'oaza-core' )
						),
						array(
							'type'        => 'attach_image',
							'param_name'  => 'play_button_image',
							'heading'     => esc_html__( 'Play Button Custom Image', 'oaza-core' ),
							'description' => esc_html__( 'Select image from media library. If you use this field then play button color and button size options will not work', 'oaza-core' )
						),
						array(
							'type'        => 'attach_image',
							'param_name'  => 'play_button_hover_image',
							'heading'     => esc_html__( 'Play Button Custom Hover Image', 'oaza-core' ),
							'description' => esc_html__( 'Select image from media library. If you use this field then play button color and button size options will not work', 'oaza-core' )
						)
					)
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$args   = array(
			'custom_class'            => '',
			'video_link'              => '#',
			'video_image'             => '',
			'play_button_color'       => '',
			'play_button_bg_color'    => '',
			'play_button_size'        => '',
			'play_button_bg_size'     => '',
			'play_button_image'       => '',
			'play_button_hover_image' => ''
		);
		$params = shortcode_atts( $args, $atts );

		$params['holder_classes']        = $this->getHolderClasses( $params );
		$params['play_button_styles']    = $this->getPlayButtonStyles( $params );
		$params['play_button_bg_styles'] = $this->getPlayButtonBackgroundStyles( $params );

		$html = oaza_core_get_shortcode_module_template_part( 'templates/video-button', 'video-button', '', $params );
		
		return $html;
	}
	
	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		$holderClasses[] = ! empty( $params['video_image'] ) ? 'mkdf-vb-has-img' : '';
		$holderClasses[] = ! empty( $params['play_button_image'] ) ? 'mkdf-vb-has-play-img' : '';

		return implode( ' ', $holderClasses );
	}

	private function getPlayButtonStyles( $params ) {
		$styles = array();

		if ( ! empty( $params['play_button_color'] ) ) {
			$styles[] = 'color: ' . $params['play_button_color'];
		}

		if ( ! empty( $params['play_button_size'] ) ) {
			$styles[] = 'font-size: ' . oaza_mikado_filter_px( $params['play_button_size'] ) . 'px';
		}

		return implode( ';', $styles );
	}

	private function getPlayButtonBackgroundStyles( $params ) {
		$styles = array();

		if ( ! empty( $params['play_button_bg_color'] ) ) {
			$styles[] = 'background-color: ' . $params['play_button_bg_color'];
		}

		if ( ! empty( $params['play_button_bg_size'] ) ) {
			$styles[] = 'width: ' . oaza_mikado_filter_px( $params['play_button_bg_size'] ) . 'px';
			$styles[] = 'height: ' . oaza_mikado_filter_px( $params['play_button_bg_size'] ) . 'px';
		}

		return implode( ';', $styles );
	}
}