<?php

if ( ! function_exists( 'oaza_mikado_map_post_audio_meta' ) ) {
	function oaza_mikado_map_post_audio_meta() {
		$audio_post_format_meta_box = oaza_mikado_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Audio Post Format', 'oaza' ),
				'name'  => 'post_format_audio_meta'
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_audio_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Audio Type', 'oaza' ),
				'description'   => esc_html__( 'Choose audio type', 'oaza' ),
				'parent'        => $audio_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Audio Service', 'oaza' ),
					'self'            => esc_html__( 'Self Hosted', 'oaza' )
				)
			)
		);
		
		$mkdf_audio_embedded_container = oaza_mikado_add_admin_container(
			array(
				'parent' => $audio_post_format_meta_box,
				'name'   => 'mkdf_audio_embedded_container'
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_post_audio_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio URL', 'oaza' ),
				'description' => esc_html__( 'Enter audio URL', 'oaza' ),
				'parent'      => $mkdf_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'mkdf_audio_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		oaza_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_post_audio_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio Link', 'oaza' ),
				'description' => esc_html__( 'Enter audio link', 'oaza' ),
				'parent'      => $mkdf_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'mkdf_audio_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'oaza_mikado_action_meta_boxes_map', 'oaza_mikado_map_post_audio_meta', 23 );
}